import React from 'react';
import { observer } from 'mobx-react';
import './RulePage.less';
import API from "@/api";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import store from "@/store/store.ts";
import HomePage from '../HomePage/HomePage';

@observer
class RulePage extends React.Component<any, any> {

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    render() {
        const { ruleImg } = store.frontVariable;
        return <div className="rulepage">
            <img className="bg"
                src={ruleImg}
            />
            <span className="back" onClick={this.clickBack}></span>
        </div>;
    }
}

export default RulePage;