"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./choice_challenge.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import store from "../../store/store.ts";
import { toJS } from "mobx";

@observer
class Choice_challenge extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      activeIndex: 0, // 默认第一项
    };
  }

  handleClick = (index) => {
    this.setState({ activeIndex: index });
  };

  handlechallenge = () => {
    ModalCtrl.closeModal();
    //todo
  };

  // handleclose = () => {
  //   ModalCtrl.closeModal();
  // }

  render() {
    const { activeIndex } = this.state;
    const { challengeConfigList = [] } = store?.taskInfo || {};
    console.log(toJS(store?.taskInfo),111)

    return (
      <div className="choice_challenge modal_center">
        <span className="bg"></span>

        <div className="list">
          {challengeConfigList.length > 0 &&
            challengeConfigList.map((item, index) => (
              <div
                className="sample"
                key={index}
                onClick={() => this.handleClick(index)}
              >
                <span
                  className={activeIndex === index ? "s_bg2" : "s_bg1"}
                ></span>
                <img
                  className="icon"
                  src={item.prizeImg}
                  alt={item.prizeName}
                />
                <span className="demand">
                  连续打卡{item.challengeTotalDay}天
                </span>
                <span className="name">{item.prizeName}</span>
              </div>
            ))}
        </div>

        <span className="title"></span>
        <span className="tip"></span>
        <Button
          className="challenge"
          onClick={() => this.handlechallenge(activeIndex)}
        />
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Choice_challenge;
