'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './privacymodal.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';

@observer
class PrivacyModal extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            countdown: 3, // 倒计时秒数
            canConfirm: false // 是否可以确认
        };
        this.countdownTimer = null; // 倒计时定时器

        // 隐私条款内容
        this.PRIVACY_CONTENT = `
<div style="padding: 20px; color: #595959; font-family: 宋体, SimSun, serif; line-height: 1.8; font-size: 14px;">
<p style="text-indent: 2em; margin-bottom: 15px;">湖南口味王集团有限责任公司（简称"我们"）依据《中华人民共和国网络安全法》、《中华人民共和国个人信息保护法》、《信息安全技术个人信息安全规范》以及其他相关法律法规和技术规范对《口味王隐私条款》（简称"隐私条款"）进行了更新，详细说明了我们在收集、使用和存储您相关个人信息时的相关规则。为了更好的保护您的个人信息，建议您仔细阅读更新后的《口味王隐私条款》，尤其是以黑色加粗的条款。如您对本隐私条款条款有任何异议或疑问，您可通过本《口味王隐私条款》第九条"联系我们"中公布的联系方式与我们沟通。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>一、引言</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">1.1《口味王隐私条款》适用于向您提供的所有产品及服务，包括小程序、移动客户端（"APP"）及其他客户端，口味王在任何第三方平台上建立的线上渠道（以下统称"口味王线上渠道"）。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">1.2 请您在使用各项产品和/或服务前，仔细阅读并充分理解本隐私条款的全部内容。一旦您使用或继续使用的产品/服务，即表示您同意我们按照本隐私条款使用和处理您的相关信息。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">1.3 我们可能会不时依据法律法规或业务调整对本隐私条款进行修订。当本隐私条款发生变更后，我们会在版本更新后通过在显著位置提示或推送通知、消息等形式向您展示变更后的内容。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">1.4 您需理解，只有在您确认并同意变更后的《口味王隐私条款》，我们才会依据变更后的隐私条款收集、使用、处理和存储您的个人信息；您有权拒绝同意变更后的隐私条款，但请您知悉，一旦您拒绝同意变更后的隐私条款，可能导致您不能或不能继续完整使用的相关服务和功能，或者无法达到我们拟达到的服务效果。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">1.5 在您同意App隐私条款后，我们将进行集成SDK的初始化工作，会收集您的android_id、IP地址、Mac地址、IMEI、IMSI和应用安装列表，以保障正常数据统计和安全风控。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>二、我们如何收集和使用您的个人信息</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">2.1 我们深知个人信息对您的重要性，并会尽全力保护您的个人信息安全可靠。我们致力于维持您对我们的信任，恪守以下原则，保护您的个人信息：权责一致原则、目的明确原则、选择同意原则、最少够用原则、确保安全原则、主体参与原则、公开透明原则等。同时，我们承诺，我们将按业界成熟的安全标准，采取相应的安全保护措施来保护您的个人信息。如果我们欲将您的个人信息用于本隐私条款未载明的其它用途，或基于特定目的将收集而来的信息用于其他目的，我们会及时以合理的方式向您告知，并在使用前再次征得您的同意。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">2.2 个人信息是指以电子或者其他方式记录的能够单独或者与其他信息结合识别特定自然人身份或者反映特定自然人活动情况的各种信息。本隐私条款中可能涉及的个人信息包括：基本信息（包括个人姓名、生日、性别、个人电话号码）；网络身份标识信息（包括账号、IP地址及与前述有关的密码）；个人常用设备信息（包括设备名称、设备型号、操作系统和应用程序版本、设备设置、唯一设备标识符、设备环境等软硬件特征信息）；个人位置信息（包括精准定位信息、经纬度以及WLAN接入点等传感器信息）；个人敏感信息是指一旦泄露、非法提供或滥用可能危害人身和财产安全，极易导致个人名誉、身心健康受到损害或歧视性待遇等的个人信息，本隐私条款中可能涉及的个人敏感信息包括：您的生物识别特征（静态或动态的面部特征）；个人身份信息（包括身份证、驾驶证、户口本）；网络身份识别信息（包括账户名、账户昵称、及与前述有关的密码与密码保护问题和答案）；个人财产信息（银行账号、交易和消费记录、信贷记录以及虚拟财产信息）；其他信息（行踪轨迹、住宿信息、精准定位信息）；14周岁以下的儿童信息。以上个人信息和个人敏感信息包含的内容出自于《信息安全技术个人信息安全规范》。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>三、我们如何使用Cookie和同类技术</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">3.1 Cookie为确保网站正常运转、为您获得更轻松的访问体验、向您推荐您可能感兴趣的内容，我们会在您的计算机或移动设备上存储名为Cookie的小数据文件。Cookie通常包含标识符、站点名称以及一些号码和字符。借助于Cookie，网站能够存储您的偏好数据。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>四、我们如何共享、转让、公开披露您的个人信息</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">4.1 共享我们不会向第三方共享你的个人信息，除非经过你本人明确授权同意，但在下列情况下，我们可能会共享的个人信息：</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">4.1.1 您的个人信息可能会在我们的关联公司之间共享。我们只会共享必要的个人信息（为便于您使用账号使用关联公司的其他产品或服务，识别账号异常或保护关联公司或其他用户或公众的人身财产安全免遭侵害，我们会在关联公司内共享您必要的账户信息）且会受本隐私群条款中所声明目的的约束，如果我们共享您的个人敏感信息或关联公司改变个人信息的使用及处理目的，将再次征求您的授权同意。本条款所称"关联公司"指的是直接或者间接控制口味王，或受口味王控制，或者与口味王一起受共同控制的任何机构。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>五、我们如何保护您的个人信息</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">5.1 我们使用符合业界标准的安全防护措施保护您提供的个人信息，防止数据遭到未经授权的访问、公开披露、使用、修改，防止数据发生损坏或丢失。我们将在合理的安全水平内使用各种安全保护措施以保障信息的安全。例如，我们会使用加密技术（例如，SSL）、匿名化处理等手段来保护你的个人信息。我们已建立访问控制机制，确保只有授权人员才可以访问个人信息；我们不时的举办安全和隐私保护培训课程，加强员工对于保护个人信息重要性的认识。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>六、您的权利</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">我们理解您对个人信息的关注，为了你可以更加便捷地访问、更正、补充、删除您的个人信息，同时保障你撤回对个人信息使用的同意及注销账号的权利，我们在产品设计中为你提供了相应的操作设置，你可以参考下面的指引进行操作。此外，我们还设置了投诉举报渠道，你的意见将会得到及时的处理。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>七、我们如何存储您的个人信息</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">7.1 信息存储的地点我们会按照法律法规规定，将中华人民共和国境内收集的用户个人信息存储于中国境内，但以下情形除外：法律法规有明确规定的；单独征得您的授权同意；您主动发起的跨境预定、下单、交易等个人行为。在上述情形中，我们会并要求数据接收方按照本隐私条款以及其他相关的安全保密措施来处理个人信息。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>八、我们如何处理未成年的个人信息</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">我们的产品、网站和服务主要面向成人（年满18周岁）。如果没有父母或监护人的同意，儿童不应创建自己的个人信息主体账户。对于经父母同意而收集儿童个人信息的情况，我们只会在受到法律允许、父母或监护人明确同意或者保护儿童所必要的情况下使用或公开披露此信息。尽管当地法律和习俗对儿童的定义不同，但我们将不满14周岁的任何人均视为儿童。如果我们发现自己在未事先获得可证实的父母同意的情况下收集了儿童的个人信息，则会设法尽快删除相关数据。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>九、联系我们</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">9.1 如您对《口味王隐私条款》的内容或使用我们的服务时遇到的与隐私保护相关的事宜有任何疑问或进行咨询或投诉时，您均可以通过如下任一方式与我们取得联系：</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">（1）您可找到我们平台上产品功能页面中在线客服或者在线提交反馈意见与我们联系；</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">（2）您还可以通过拨打400-103-0808热线电话，与我司客服取得联系，客服将为您提供服务，解决您的问题。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>十、本条款如何更新</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">10.1 为了给您提供更好的服务，我们会根据产品的更新情况及法律法规的相关要求更新《口味王隐私条款》的条款，该等更新构成《口味王隐私条款》的一部分。未经您明确同意，我们不会削减您按照本条款所应享有的权利。如该等更新造成您在本《口味王隐私条款》下权利的实质减少或重大变更，我们将在本条款生效前通过在显著位置提示或向您发送推送消息或以其他方式通知您，若您继续使用我们的服务，即表示您充分阅读、理解并同意受经修订的《口味王隐私条款》的约束。</p>

<p style="text-indent: 21pt; margin-bottom: 15px;"><strong>十一、争议解决</strong></p>
<p style="text-indent: 21pt; margin-bottom: 15px;">11.1 本隐私条款的解释及争议解决均应适用中华人民共和国大陆地区法律。任何因本隐私条款以及我们处理您个人信息事宜引起的争议，您同意向长沙市开福区人民法院提起诉讼来寻求解决方案。</p>
<p style="text-indent: 21pt; margin-bottom: 15px;">11.2 如果您认为我们处理个人信息的行为损害了您的合法权益，您也可以选择向有关政府部门进行反映。注：《口味王隐私条款》版本更新日期为2024年10月20日，于2024年11月20日正式生效，在2024年10月20日至2024年11月20日期间，如您认为更新的隐私条款对您更为有利，我们同意双方适用新的隐私条款内容。</p>
</div>
`;


    }

    componentDidMount() {
        // 启动倒计时
        this.startCountdown();
    }

    componentWillUnmount() {
        // 清除倒计时定时器
        if (this.countdownTimer) {
            clearInterval(this.countdownTimer);
        }
    }

    // 启动倒计时
    startCountdown() {
        this.countdownTimer = setInterval(() => {
            this.setState(prevState => {
                const newCountdown = prevState.countdown - 1;
                if (newCountdown <= 0) {
                    clearInterval(this.countdownTimer);
                    return {
                        countdown: 0,
                        canConfirm: true
                    };
                }
                return {
                    countdown: newCountdown
                };
            });
        }, 1000);
    }


    // 关闭弹窗
    handleClose() {
        // 清除定时器
        if (this.countdownTimer) {
            clearInterval(this.countdownTimer);
        }
        ModalCtrl.closeModal(PrivacyModal);
        wx.miniProgram.navigateBack();
    }

    // 关闭弹窗并执行确认操作
    handleConfirm() {
        // 如果倒计时未结束，不允许确认
        if (!this.state.canConfirm) {
            return;
        }

        // 清除定时器
        if (this.countdownTimer) {
            clearInterval(this.countdownTimer);
        }
        ModalCtrl.closeModal(PrivacyModal);
    }





    render() {
        return (
            <div className="privacymodal" >
                <div className="privacymodal-container" >
                    <span
                        className="privacymodal-closebtn"
                        onClick={this.handleClose.bind(this)}
                    ></span>
                    <div className="privacymodal-title">用户协议</div>
                    <div
                        className="privacymodal-content"
                        dangerouslySetInnerHTML={{ __html: this.PRIVACY_CONTENT || '' }}
                    />

                    <div className="privacymodal-buttons">
                        <button
                            className="privacymodal-button-confirm"
                            onClick={this.handleConfirm.bind(this)}
                            disabled={!this.state.canConfirm}
                        >
                            {this.state.canConfirm ? '确认' : `确认(${this.state.countdown}s)`}
                        </button>
                    </div>
                </div>
            </div>
        );
    }
}

export default PrivacyModal;