'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './finish_task.less';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button } from '@grace/ui';
import { SvgaPlayer } from '@grace/svgaplayer';

import lightSvga from "../../assets/svga/1通用弹窗氛围.svga";

@observer
class Finish_task extends React.Component {
  constructor(props) {
    super(props);
  }

  handleknow = () => {
    ModalCtrl.closeModal();
  }

  handleclose = () => {
    ModalCtrl.closeModal();
  }

  render() {
    const { title } = this.props;
    console.log(title);
    
    
    return (
      <div className="finish_task modal_center">
        <SvgaPlayer className="dongxiao" src={lightSvga}/>
        <span className="bg"></span>
        <span className="line"></span>
        <span className="title">{title}任务完成</span>
        <span className="tip1">打卡任务完成啦!</span>
        <span className="tip2">继续保持哦！</span>
        <Button className="know" onClick={this.handleknow} />
        <span className="ribbon"></span>
        <span className="ditu"></span>
        <Button className="close" onClick={this.handleclose} />
      </div>
    );
  }
}
export default Finish_task;
