import React from "react";
import { observer } from "mobx-react";
import styles from "./ObtainPanel.module.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import classNames from "classnames";
import { SvgaPlayer } from "@grace/svgaplayer";
import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";


export interface IObtainPanelProps {
  creditNum: number,
  isExp: boolean,
}

@observer
class ObtainPanel extends React.Component<IObtainPanelProps> {

  componentDidMount() {
  }

  close = () => {
    ModalCtrl.closeModal();
  };

  clickGet = () => {
    ModalCtrl.closeModal();
  };


  render() {

    const {creditNum, isExp} = this.props;

    return <div className={classNames(styles.ObtainPanel, "modal_center")}>
      <SvgaPlayer className={styles.bgEffect} src={bgEffectSvga}/>
      <div className={styles.bg}/>
      <div className={styles.tip}>恭喜获得{creditNum}积分</div>

      <div className={classNames({
        [styles.expansion]: isExp,
        [styles.normal]: !isExp,
      })}/>

      <div className="com_banner"/>

      <Button className={styles.ok} onClick={this.clickGet}/>
      <Button className={styles.close} onClick={this.close}/>
    </div>;
  }

}

export default ObtainPanel;
