import React from "react";
import { observer } from "mobx-react";
import "./WedExpPanel.less";
import { Button } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { SvgaPlayer } from "@grace/svgaplayer";

import bgEffectSvga from "@/assets/svga/2输出签到成功弹窗.svga";
import VideoPanel from "@/panels/VideoPanel/VideoPanel.tsx";
import classNames from "classnames";

export interface IWedExpPanelProps {
  signCredits: number;
  extraCredits: number;
  boolLimit: boolean;
  multipleValue: number;
  url: string;
  taskId: string;
  newLuckCreditsNum: number;
}

@observer
class WedExpPanel extends React.Component<IWedExpPanelProps> {

  componentDidMount() {
  }

  clickClose = () => {
    ModalCtrl.closeModal();
  };

  clickVideo = _asyncThrottle(async () => {
    const { url, taskId } = this.props;

    ModalCtrl.closeModal();
    ModalCtrl.showModal(VideoPanel, { taskId, url, isExp: true });
  });

  render() {

    const { signCredits, extraCredits, multipleValue } = this.props;

    const isVip = !!extraCredits;

    return <div className="WedExpPanel modal_center">
      <SvgaPlayer className="bgEffect" src={bgEffectSvga}/>
      <div className="bg"/>

      <div className="tip">
        获得{signCredits + extraCredits}积分<br/>
        解锁周三限时奖励
      </div>
      {
        isVip
          ? <div className="vip">
            <div className="img"/>
            <div className="multuple">{multipleValue}x</div>
          </div>
          : <div className="normal">
            <div className="img"/>
            <div className="multuple">{multipleValue}x</div>
          </div>
      }

      <div className="taskBg"/>
      <div className="logo"/>
      <div className="txt">
        观看品牌视频15s<br/>
        积分膨胀至{(signCredits + extraCredits) * multipleValue}积分
      </div>

      <div className="com_banner"/>

      <Button className={classNames("btn", isVip ? "md8" : "md7")} onClick={this.clickVideo}/>
      <Button className="close" onClick={this.clickClose}/>
    </div>;
  }
}

export default WedExpPanel;
