import { Base, IBase } from "@/pages/HomePage/Top/base/Base.ts";
import { Assets, Container, Sprite, Text, Ticker } from "pixi.js";
import { Ease, Tween } from "@/core/tween";
import { _asyncThrottle, prefixInteger } from "@/utils/utils.ts";
import { reactor, observer } from "@/pages/HomePage/Top/mobx/decorators.ts";
import { handleLogClick, handleLogExposure } from "@/MD.ts";


@observer
export class PlantGameBubble extends Container implements IBase {

  text: Text;
  time: Text;
  id: string;

  constructor() {
    super();
    this.onLoad();
    this.on("pointerup", this.onPointerUp, this);
  }

  onLoad() {
    this.position.set(90, 440);

    this.addChild(new Sprite(Assets.get("去种树.png")))
      .anchor.set(0.5);

    this.effect();
  }

  onPointerUp = _asyncThrottle(async () => {
    location.href = "https://89420-activity.dexfu.cn/projectx/p124e3402/index.html?appID=89420"
  });

  effect() {
    const y = this.y;
    Tween.get(this, { loop: true })
      .to({ y: y + 25 }, 2000, Ease.quadInOut)
      .to({ y: y }, 2000, Ease.quadInOut);
  }

  onUpdate(time: Ticker) {

  }

  onDestroy() {
    Tween.removeTweens(this);
  }

  destroy() {
    this.onDestroy();
    super.destroy();
  }

}
