"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./consume_qg.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Finish_task from "../finish_task/finish_task";
import API from "../../../src/api/index";
import store from "../../../src/store/store.ts";
import { handleLogExposure, handleLogClick } from "@/MD";

@observer
class Consume_qg extends React.Component {
  constructor(props) {
    super(props);
  }

  handleclock = async (code) => {
    handleLogClick(17);
    const { success } = await API.getChallenegeComplete({ taskCode: code });
    if (success) {
      ModalCtrl.closeModal();
    }
    store.getTaskInfo();
  };

  handleclose = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { n = 0, code, title } = this.props;
    handleLogExposure(17);
    return (
      <div className="consume_qg modal_center">
        <span className="bg"></span>
        <span className="tile"></span>
        <span className="tip1">消耗{n}青果</span>
        <span className="tip2">完成打卡</span>
        <Button className="close" onClick={this.handleclose} />
        <Button className="clock" onClick={() => this.handleclock(code)} />
        <span className="icon"></span>
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Consume_qg;
