"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./consume_credits.less";
import { Button } from "@grace/ui";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import Finish_task from "../finish_task/finish_task";
import API from "../../../src/api/index";
import store from "../../../src/store/store.ts";
import { pre_reduce_score } from "../../store/credits.js";
import { handleLogExposure, handleLogClick } from "@/MD";

@observer
class Consume_credits extends React.Component {
  constructor(props) {
    super(props);
  }

  handleclock = async (n, code) => {
    handleLogClick(16)
    await pre_reduce_score(
      {
        toPlaywayId: "challenge",
        toActionId: "taskComplete",
        desc: "taskComplete_credits_desc",
        credits: n,
      },
      async () => {
        const { success } = await API.getChallenegeComplete({
          taskCode: code,
          ticket: store.ticketNum,
        });
        if (success) {
          ModalCtrl.closeModal();
        }
        store.getTaskInfo()
      }
    );
  };

  handleclose = () => {
    ModalCtrl.closeModal();
  };

  render() {
    const { n = 0, code, title } = this.props;
    handleLogExposure(16)
    return (
      <div className="consume_credits modal_center">
        <span className="bg"></span>
        <span className="tile"></span>
        <span className="tip1">消耗{n}积分</span>
        <span className="tip2">完成打卡</span>
        <Button className="close" onClick={this.handleclose} />
        <Button
          className="clock"
          onClick={() => this.handleclock(n, code, title)}
        />
        <span className="icon"></span>
        <span className="ditu"></span>
      </div>
    );
  }
}
export default Consume_credits;
