import React from "react";
import { observer } from "mobx-react";
import styles from "./GuidePanel.module.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import classNames from "classnames";
import store from "@/store/store.ts";
import API from "@/api";
import { _asyncThrottle } from "@/utils/utils.ts";


export interface IGuidePanelProps {
}

@observer
class GuidePanel extends React.Component<IGuidePanelProps> {

  state = {
    step: 1,
  }

  componentDidMount() {
  }

  clickGuide = () => {
    const { step } = this.state;
    if (step == 6)  return;

    this.setState({
      step: step + 1,
    });
  };

  clickGuide6Btn = _asyncThrottle(async () => {
    const { step } = this.state;
    if (step != 6)  return;

    await API.completeGuide();

    ModalCtrl.closeModal(GuidePanel);

    store.doSign();
  });


  render() {

    const { expireDays } = store.indexData;
    const { step } = this.state;
    const guideSrc = new URL(`../../assets/GuidePanel/引导${step}.png?x-oss-process=image/format,webp`, import.meta.url).href;

    return <div className={styles.GuidePanel} onClick={this.clickGuide}>

      <div className={styles.guide} style={{
        backgroundImage: `url(${guideSrc})`,
      }}/>

      {
        step == 6
          ? <>
            <div className={styles.guide6Tip}>
              超过{expireDays}天未登录<br/>
              积分会清零<br/>
              记得来“取积分”哦
            </div>

            <Button className={styles.guide6Btn} onClick={this.clickGuide6Btn}/>
          </>
          : <div className={styles.tip}>点击屏幕继续</div>
      }

    </div>;
  }

}

export default GuidePanel;
