import { Base } from "@/pages/HomePage/Top/base/Base.ts";
import { Assets, Sprite, Text } from "pixi.js";

export interface IBubbleInfo {
  id: string;
  creditsNum: string,
  expireTime: number,
  type: "1" | "2",  // 1-签到气泡 2-积分气泡
}

export class Bubble extends Base {

  text: Text;
  time: Text;

  protected onLoad() {

    this.addChild(new Sprite(Assets.get("黄色气泡.png")))
      .anchor.set(0.5, 0.5);

    this.text = this.addChild(new Text({
      text: `210`,
      style: {
        fontSize: 42,
        fill: 0xffffff,
        align: "center",
        fontWeight: "bold",
      }
    }));
    this.text.anchor.set(0.5, 0.5);

    this.time = this.addChild(new Text({
      text: `23:59:59`,
      style: {
        fontSize: 21,
        fill: 0xffffff,
        align: "center",
        fontWeight: "bold",
      }
    }));
    this.time.anchor.set(0.5, 0.5);
    this.time.position.set(0, 65);

  }

  setInfo(info: IBubbleInfo) {

  }

}
