// pages/activity/activity.ts
import { ComponentWithStore } from "mobx-miniprogram-bindings";
import { store } from "../../store/store";
import { _asyncThrottle } from "../../utils/util";

ComponentWithStore({
    storeBindings: {
        store,
        fields: {
            showPhoneBtn: () => !store.homeInfo.mobile,
            activityInfo: () => store.activityInfo,
        },
        actions: {},
    },
    /**
     * 页面的初始数据
     */
    data: {
    },

    created() {
        store.updateActivity();
    },
    methods: {
        // 跳转活动详情页
        jumpDetailPage: _asyncThrottle(async function (e) {
            const item = e.currentTarget.dataset.item
            wx.navigateTo({ url: `/pages/activityDetail/activityDetail?url=${item.img}` })
        }),

        onShareAppMessage() {
            return {
                title: '自定义转发标题',
                path: '/page/index/index?id=123',
            }
        }
    },

})

