import env from './config';

const headersConfig = {
  'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
}

export let request = (config: any) => new Promise((resolve, reject) => {
  const method = config.method.toUpperCase() || 'GET';
  const { BASE_URL } = env;

  wx.request({
    method,
    url: config.url ? `${BASE_URL}${config.url}` :  '',
    data: config.data,
    header: {
      ...headersConfig,
      ...config.headers
    },
    success(response) {
        if (+response.statusCode === 200) {
            resolve(response.data);
        } else {
            reject(new Error(`请求失败 statusCode: ${response.statusCode}`));
        }
    },
    fail(error) { 
      reject(new Error(error.errMsg));
     },
  })
})