// pages/activity/activity.ts
import { ComponentWithStore } from "mobx-miniprogram-bindings";
import { store } from "../../store/store";
import { _asyncThrottle } from "../../utils/util";
import { dbLogin } from "../../utils/request";

ComponentWithStore({
    storeBindings: {
        store,
        fields: {
            showPhoneBtn: () => !store.homeInfo.mobile,
            activityInfo: () => store.activityInfo,
            homeInfo: () => store.homeInfo,
        },
        actions: {},
    },
    /**
     * 页面的初始数据
     */
    data: {
    },

    created() {
        store.updateActivity();
    },
    methods: {
        onShow() {
            store.doLog(507, 9)
        },
        // 跳转活动详情页
        jumpDetailPage: _asyncThrottle(async function (e) {
            const item = e.currentTarget.dataset.item
            const index = e.currentTarget.dataset.index
            console.log('item', item, index);
            
            store.doLog(508, 5 + index)
            wx.navigateTo({ url: `/pages/activityDetail/activityDetail?imgUrl=${item.detailImg}` })
        }),
        getPhoneNumber(e: any) {
            if (e.detail?.iv && e.detail?.encryptedData) {
                wx.login({
                    success: async (res) => {
                        console.log(res.code)
                        await dbLogin({
                            code: res.code,
                            iv: e.detail.iv,
                            encryptedData: e.detail.encryptedData,
                        });
                    },
                });
            }
        },

        // onShareAppMessage() {
        //     return {
        //         title: '自定义转发标题',
        //         path: '/page/index/index?id=123',
        //     }
        // }
    },

})

