// my.ts
// 获取应用实例
import { ComponentWithStore } from "mobx-miniprogram-bindings";
import { store } from "../../store/store";
import { dbLogin } from "../../utils/request";
import { _asyncThrottle, defaultInfo } from "../../utils/util";

const app = getApp<IAppOption>()

ComponentWithStore({
  storeBindings: {
      store,
      fields: {
          showPhoneBtn: () => !store.homeInfo.mobile,
      },
      actions: {},
  },
  data: {
    defaultInfo: defaultInfo,
    userInfo: {
      avatarUrl: '',
      nickName: '',
    },
    canIUseGetUserProfile: wx.canIUse('getUserProfile'),
    canIUseNicknameComp: wx.canIUse('input.type.nickname'),
  },
  methods: {
    onShow() {
      store.doLog(507, 11)
      this.setData({
        userInfo: {
          avatarUrl: store.homeInfo.avatar,
          nickName: store.homeInfo.nickname,
        },
      });
    },
    getPhoneNumber(e: any) {
        if (e.detail?.iv && e.detail?.encryptedData) {
            wx.login({
                success: async (res) => {
                    console.log(res.code)
                    await dbLogin({
                        code: res.code,
                        iv: e.detail.iv,
                        encryptedData: e.detail.encryptedData,
                    });
                },
            });
        }
    },
    async onChooseAvatar(e: any) {
      const { avatarUrl } = e.detail
      console.log('avatarUrl', avatarUrl);

      wx.getFileSystemManager().readFile({
        filePath: e.detail.avatarUrl, //地址
        encoding: 'base64', //编码格式
        success: async (res) => {
          let base64 = 'data:image/png;base64,' + res.data
          const data = await store.doImgUpload(base64)
          console.info('头像上传后data', data);
          if (data) {
            await dbLogin({
              avatar: data,
            });
            const { nickName } = this.data.userInfo
            this.setData({
              "userInfo.avatarUrl": data,
            })
          }
        }
      })
    },
    async onInputChange(e: any) {
      const nickName = e.detail.value
      if (nickName) {
        await dbLogin({
          nickname: nickName,
        });
        const { avatarUrl } = this.data.userInfo
        this.setData({
          "userInfo.nickName": nickName,
        })
      }
    },
    getUserProfile() {
      // 推荐使用wx.getUserProfile获取用户信息，开发者每次通过该接口获取用户个人信息均需用户确认，开发者妥善保管用户快速填写的头像昵称，避免重复弹窗
      wx.getUserProfile({
        desc: '展示用户信息', // 声明获取用户个人信息后的用途，后续会展示在弹窗中，请谨慎填写
        success: (res) => {
          console.log(res)
          this.setData({
            userInfo: res.userInfo,
          })
        }
      })
    },
  },

})
