// index.ts
// 获取应用实例
import { ComponentWithStore } from "mobx-miniprogram-bindings";
import { store } from "../../store/store";
import { dbLogin, request } from "../../utils/request";
import { API_PATH } from "../../utils/config";
import { _asyncThrottle, defaultInfo } from "../../utils/util";

const app = getApp<IAppOption>()

ComponentWithStore({
    storeBindings: {
        store,
        fields: {
            homeInfo: () => store.homeInfo,
            mobile: () => store.homeInfo.mobile || "-",
        },
        actions: {},
    },
    data: {
        defaultInfo: defaultInfo,
        showGetPanel: false,
        showAlGetPanel: false,
        showPhoneBtn: false,
        userInfo: {
            avatarUrl: '',
            nickName: '',
        },
        canIUseGetUserProfile: wx.canIUse('getUserProfile'),
        canIUseNicknameComp: wx.canIUse('input.type.nickname'),
        isFirstIndex: true,
    },
    created() {
        // 登录
        wx.login({
            success: async (res) => {
                console.log(res.code)
                // 发送 res.code 到后台换取 openId, sessionKey, unionId
                await dbLogin({code: res.code});
                store.doLog(507, 10)
                await this.updateHomeInfo();
                const {channel, city} = this.options || {};
                store.paramsObj = {channel, city};
                this.setData({ isFirstIndex: false })
            },
        });
    },
    methods: {
        async onShow() {
            if (!this.data.isFirstIndex) {
              store.doLog(507, 10)
              await this.updateHomeInfo();
            }
        },
        getPhoneNumber(e: any) {
            console.log(e.detail)
            console.log(e.detail.iv)
            console.log(e.detail.encryptedData)

            if (e.detail?.iv && e.detail?.encryptedData) {
                wx.login({
                    success: async (res) => {
                        console.log(res.code)
                        await dbLogin({
                            code: res.code,
                            iv: e.detail.iv,
                            encryptedData: e.detail.encryptedData,
                        });
                        await this.updateHomeInfo();
                    },
                });
            }
        },

        async updateHomeInfo() {
            const {channel, city} = this.options || {};

            await store.updateHomeInfo({channel, city});
            const {mobile, first} = store.homeInfo;

            if (!mobile) {
                this.setData({
                    showPhoneBtn: true,
                });
            } else {
                this.setData({
                    showGetPanel: channel && first && !store.paramsObj.channel,
                    showAlGetPanel: channel && !first && !store.paramsObj.channel,
                    showPhoneBtn: false,
                    userInfo: {
                        avatarUrl: store.homeInfo.avatar,
                        nickName: store.homeInfo.nickname,
                    },
                });
            }

        },

        clickSubscribe: _asyncThrottle(async function () {
            console.log('clickSubscribe', this)
            store.doLog(508, 3)
            const { success, message } = await request({
                url: API_PATH.subscribe,
            });
            if (!success) {
              wx.showToast({
                  title: message,
                  icon: 'none',
              });
            }
            await this.updateHomeInfo();
        }),

        // 跳转活动页
        jumpActPage: _asyncThrottle(async function () {
            store.doLog(508, 4)
            wx.switchTab({url: "/pages/activity/activity"})
        }),

        closeGetPanel() {
            this.setData({
                showGetPanel: false,
            });
            // 定位权限未通过 先不做
            // this.getPos()
        },
        closeAlGetPanel() {
            this.setData({
                showAlGetPanel: false,
            });
            // 定位权限未通过 先不做
            // this.getPos()
        },
        getPos() {
            wx.getLocation({
                type: 'wgs84',
                success(res) {
                    const latitude = res.latitude
                    const longitude = res.longitude
                    const speed = res.speed
                    const accuracy = res.accuracy
                }
            })
        },
        async onChooseAvatar(e: any) {
            const {avatarUrl} = e.detail
            console.log('avatarUrl', avatarUrl);

            wx.getFileSystemManager().readFile({
                filePath: e.detail.avatarUrl, //地址
                encoding: 'base64', //编码格式
                success: async (res) => {
                    let base64 = 'data:image/png;base64,' + res.data
                    const data = await store.doImgUpload(base64)
                    console.info('头像上传后data', data);
                    if (data) {
                        await dbLogin({
                            avatar: data,
                        });
                        await this.updateHomeInfo();
                    }
                }
            })
        },
        async onInputChange(e: any) {
            const nickName = e.detail.value
            if (nickName) {
                await dbLogin({
                    nickname: nickName,
                });
                await this.updateHomeInfo();
            }
        },
        getUserProfile() {
            // 推荐使用wx.getUserProfile获取用户信息，开发者每次通过该接口获取用户个人信息均需用户确认，开发者妥善保管用户快速填写的头像昵称，避免重复弹窗
            wx.getUserProfile({
                desc: '展示用户信息', // 声明获取用户个人信息后的用途，后续会展示在弹窗中，请谨慎填写
                success: (res) => {
                    console.log(res)
                    this.setData({
                        userInfo: res.userInfo,
                    })
                }
            })
        },
    },

})
