import env from './config';

const headersConfig = {
    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
}

type IReqMethod = 'OPTIONS' | 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'TRACE' | 'CONNECT';

interface IReqConfig {
    url: string;
    headers?: object;
    data?: object;
    method?: IReqMethod;
}

let loginToken: string = "";

export const request = (config: IReqConfig) => new Promise((resolve, reject) => {
    const {BASE_URL, projectId} = env;

    const {url, headers, data, method = "GET"} = config;

    const type = (method.toUpperCase() as IReqMethod) || 'GET';

    const header = {
        ...headersConfig,
        ...headers,
        loginToken,
    };

    const params = {
        ...data,
    };

    wx.request({
        method: type,
        url: `${BASE_URL}${projectId}${url}`,
        data: params,
        header,
        success(response) {
            if (+response.statusCode === 200) {
                resolve(response.data);
            } else {
                reject(new Error(`请求失败 statusCode: ${response.statusCode}`));
            }
        },
        fail(error) {
            reject(new Error(error.errMsg));
        },
    })
})