import { makeAutoObservable } from 'mobx-miniprogram'
import { request } from "../utils/request";
import { API_PATH } from "../utils/config";


class Store {

    paramsObj = {
        longitude: 0,
        latitude: 0,
        channel: '',
        city: ''
    }

    homeInfo = {
        nickname: '',
        avatar: "",
        mobile: "",
        subscribe: "",
        first: true,
        topBanners: [],
        activities: []
    }

    async updateHomeInfo(params: {
        longitude?: number,
        latitude?: number,
        channel?: string,
        city?: string,
    }) {
        // wx.showLoading({
        //     title: '加载中',
        //     mask: true,
        // });
        const { success, data, message } = await request({
            url: API_PATH.index,
            data: params,
        });

        if (!success) {
            wx.showToast({
                title: message,
                icon: 'none',
            });
            return;
        }

        this.homeInfo = data;
    }

    activityInfo = {
        topBanners: [],
        productList: [],
    }

    async updateActivity() {

        // wx.showLoading({
        //     title: '加载中',
        //     mask: true,
        // });
        const { success, data, message } = await request({
            url: API_PATH.activity,
            data: {
                channel: this.paramsObj.channel,
                city: this.paramsObj.city,
            },
        });

        if (!success) {
            wx.showToast({
                title: message,
                icon: 'none',
            });
            return;
        }

        this.activityInfo = data;
    }

    async doImgUpload(img64: string) {

        // wx.showLoading({
        //     title: '加载中',
        //     mask: true,
        // });
        const { success, data } = await request({
            url: API_PATH.imgUpload,
            method: 'POST',
            headers: {
                "Content-Type": 'application/json'
            },
            data: { img64 }
        });

        if (!success) return '';
        return data;
    }

    async doLog(pageBizId: number, eventId: number) {
        await request({
            url: API_PATH.buried,
            data: {
                pageBizId, // 埋点号
                eventId, // 事件id
            },
        });
    }

}

// 数据仓库
export const store = makeAutoObservable(new Store());