import { makeAutoObservable } from 'mobx-miniprogram'
import { request } from "../utils/request";
import { API_PATH } from "../utils/config";


class Store {

    homeInfo = {
        nickname: '',
        avatar: "",
        mobile: "",
        subscribe: "",
        first: true,
        topBanners: [],
        activities: []
    }

    async updateHomeInfo(params: {
        longitude?: number,
        latitude?: number,
        channel?: string,
        city?: string,
    }) {
        // wx.showLoading({
        //     title: '加载中',
        //     mask: true,
        // });
        const {success, data} = await request({
            url: API_PATH.index,
            data: params,
        });

        if (!success) return;

        this.homeInfo = data;
    }

    activityInfo = {
        topBanners: [],
        productList: [],
    }

    async updateActivity() {

        // wx.showLoading({
        //     title: '加载中',
        //     mask: true,
        // });
        const {success, data} = await request({
            url: API_PATH.activity,
        });

        if (!success) return;

        this.activityInfo = data;
    }
}

// 数据仓库
export const store = makeAutoObservable(new Store());