import env, { API_PATH } from './config';

const headersConfig = {
    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
}

type IReqMethod = 'OPTIONS' | 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'TRACE' | 'CONNECT';

interface IReqConfig {
    url: string;
    headers?: object;
    data?: object;
    method?: IReqMethod;
}

interface IResData {
    success: boolean;
    data?: any,
    code?: string;
    message?: string;
}

let loginToken: string = "";

export function request(config: IReqConfig) {
    return new Promise<IResData>((resolve, reject) => {
        const {BASE_URL, projectId} = env;

        let {url, headers, data, method = "GET"} = config;

        method = (method.toUpperCase() as IReqMethod) || 'GET';

        const header = {
            ...headersConfig,
            ...headers,
            loginToken,
        };

        const params = {
            ...data,
        };

        if (url.indexOf("/") != 0) {
            url = `/${projectId}/${url}`;
        }


        wx.request({
            method,
            url: `${BASE_URL}${url}?_t=${Date.now()}`,
            data: params,
            header,
            success(response) {
              console.info(`%c 收到接口返回值: ${url}\n`, "font-size: 20px; color: rgb(185, 155, 249)", response);
                if (+response.statusCode === 200) {
                    resolve(response.data as IResData);
                } else {
                    resolve({success: false});
                    // reject(new Error(`请求失败 statusCode: ${response.statusCode}`));
                }
            },
            fail(error) {
                resolve({success: false});
                // reject(new Error(error.errMsg));
            },
        })
    })
}

export async function dbLogin(
    param: {
        code?, encryptedData?, iv?, nickname?, avatar?
    }
) {

    // const {code, encryptedData = null, iv, nickname, avatar} = param;

    // const params: any = {
    //     appKey: env.appKey,
    // };

    // code && (params.code = code);
    // encryptedData && (params.encryptedData = encryptedData);
    // iv && (params.iv = iv);
    // nickname && (params.nickname = nickname);
    // avatar && (params.avatar = avatar);

    // const {success, data} = await request({
    //     url: API_PATH.login,
    //     data: params,
    // });

    // if (!success) {
    //     return;
    // }

    // loginToken = data.loginToken;
    // TODO 测试数据
    loginToken = "test";
}