export const formatTime = (date: Date) => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()

  return (
    [year, month, day].map(formatNumber).join('/') +
    ' ' +
    [hour, minute, second].map(formatNumber).join(':')
  )
}

const formatNumber = (n: number) => {
  const s = n.toString()
  return s[1] ? s : '0' + s
}



/**
 * @description: 支持异步函数的节流，防止接口时间太长击穿防连点
 * @return {Function}
 * @param fun
 * @param delay
 */
export const _asyncThrottle = (fun, delay = 2000) => {
  let last, deferTimer;
  let canClick = true;
  return function () {
    const now = Date.now();
    if (!canClick) return;

    if (last && now < last + delay) {
      // clearTimeout(deferTimer);
      // deferTimer = setTimeout(() => {
      //     last = now;
      // }, delay);
    } else {
      last = now;
      // @ts-ignore
      const ps = fun.apply(this, arguments);
      if (ps instanceof Promise) {
        canClick = false;
        ps.then(() => {
          canClick = true;
        });
      }
    }
  };
};

/** 默认信息 */
export const defaultInfo = {
  avatar: 'https://yun.duiba.com.cn/polaris/default_avator.8fa52026c1f64f47730d58eb31668c7e5e60bb59.png',
  nickname: "用户昵称"
}
