// app.ts
import { dbLogin, request } from "./utils/request";

App<IAppOption>({
    globalData: {},
    onLaunch() {
        // 展示本地存储能力
        const logs = wx.getStorageSync('logs') || []
        logs.unshift(Date.now())
        wx.setStorageSync('logs', logs)

        // 登录
        wx.login({
            success: async (res) => {
                console.log(res.code)
                // 发送 res.code 到后台换取 openId, sessionKey, unionId
                await dbLogin({code: res.code});
            },
        })
    },
})