import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer } from "../store/decorators";
import { _asyncThrottle } from "../Utils/Utils";

const { ccclass, property } = _decorator;

@observer
@ccclass('TaskTipsPop_wx')
export default class TaskTipsPop_wx extends Panel {

    static bundle = "TaskTipsPop_wx";
    static skin = "TaskTipsPop_wx";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
    }

    clickClose = () => {
        this.hidePanel();
    }

}
