import { _decorator, CCInteger, Component, instantiate, Node, Prefab, UITransform } from 'cc';
import { YCItem } from "./YCItem";

const {ccclass, property} = _decorator;

@ccclass('Y_Carousel')
export class Y_Carousel extends Component {

  @property(Prefab) itemPrefab = null;

  @property(CCInteger) speed: number = 50;
  @property(CCInteger) delay: number = 1;

  itemArr: Node[] = [];
  dateArr: any[] = [];

  topY: number = 0;
  itemH: number = 0;
  ctnH: number = 0;
  dataIdx = 0;

  isInit = false;

  start() {
  }

  init() {
    this.isInit = true;
    const item0 = instantiate(this.itemPrefab);
    this.node.addChild(item0);
    this.itemArr.push(item0);
    this.setItemData(item0);

    const {height: itemH, anchorY: itemAY} = item0.getComponent(UITransform);
    const {height: ctnH, anchorY: ctnAY} = this.node.getComponent(UITransform);

    this.itemH = itemH;
    this.ctnH = ctnH;

    this.topY = ctnH * (1 - ctnAY) - itemH * (1 - itemAY);

    item0.setPosition(0, this.topY);

    const initCount = Math.ceil(ctnH / itemH + 1);

    for (let i = 1; i < initCount; i++) {
      const item = instantiate(this.itemPrefab);
      this.node.addChild(item);
      const y = this.itemArr[i - 1].position.y - itemH;
      item.setPosition(0, y);
      this.itemArr.push(item);
      this.setItemData(item);
    }
  }

  setData(data: any[]) {
    if (!data?.length) return;
    this.dateArr = data;
    if (!this.isInit) {
      this.init();
    }
  }

  setItemData(item: Node) {
    const idx = this.dataIdx % this.dateArr.length;
    this.dataIdx++;
    item.getComponent(YCItem).setData(this.dateArr[idx]);
  }

  isDelay = false;

  update(dt: number) {
    if (!this.isInit) return;

    if (this.isDelay) return;

    const dy = -this.speed * dt;

    const item0 = this.itemArr[0];
    const ty = item0.position.y - dy;
    item0.setPosition(0, ty);

    const needSwap = ty > this.topY + this.itemH;

    if (needSwap) {
      item0.position.set(0, this.topY + this.itemH);
      this.isDelay = true;
      this.scheduleOnce(() => {
        this.isDelay = false;
      }, this.delay);
    }

    const len = this.itemArr.length;
    for (let i = 1; i < len; i++) {
      this.itemArr[i].setPosition(0, this.itemArr[i - 1].position.y - this.itemH);
    }

    if (needSwap) {
      this.itemArr.splice(0, 1);
      this.itemArr.push(item0);
      this.setItemData(item0);
    }
  }
}


