import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer } from "../store/decorators";
import { getWebData, sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle } from "../Utils/Utils";
import { runMainPage } from "../Scenes/runMain/runMainPage";
import store from "../store/store";

const { ccclass, property } = _decorator;

@observer
@ccclass('HomeGuidePanel')
export default class HomeGuidePanel extends Panel {

    static bundle = "HomeGuidePanel";
    static skin = "HomeGuidePanel";

    @property(Node) step2Box: Node = null;
    @property(Node) step3Box: Node = null;

    @property(Node) step2ClickArea: Node = null;
    @property(Node) step3ClickArea: Node = null;

    onLoad() {
        this.step2ClickArea.on(Button.EventType.CLICK, this.stepHandle);
        this.step3ClickArea.on(Button.EventType.CLICK, this.endHandle);
    }

    async start() {
    }

    // 下一步
    stepHandle = _asyncThrottle(async () => {
        const { success } = await sendWebNet(WebNetName.tcs_StepBranchGuide, { branchType: store.BRANCH_TYPE })
        if (success) {
            this.step2Box.active = false;
            this.step3Box.active = true;
        }
    })

    // 结束
    endHandle = _asyncThrottle(() => {
        this.hidePanel();
        runMainPage.ins.getIndex();
    })

}
