import Panel from "../../Module/Panel";
import { _decorator, Button, RichText, UITransform, Node, Sprite, Texture2D, ImageAsset, SpriteFrame } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const {ccclass, property} = _decorator;

import { HTMLRichText } from "../../Component/HTMLRichText/HTMLRichText";
import { getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { game } from "cc";

@observer
@ccclass('RulePanel')
export default class RulePanel extends Panel {

    static bundle = "RulePanel";
    static skin = "RulePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) spNode: Node = null;

    dom: HTMLDivElement = null;  

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        // this.setRuleTxt(getWebData(WebNetName.tcs_Index).data?.rule || "");

        if (!this.dom) {
            this.dom = document.createElement("div");
        }
  
        this.dom.innerHTML = `<div style="
              position: absolute;
              left: 1.34rem;
              top: 4.14rem;
              width: 4.85rem;
              height: 7.2rem;
              font-size: 0.21rem;
              color: #590505;
              overflow: hidden;
              overflow-y: auto;
              word-break: break-word;
          ">
              ${getWebData(WebNetName.tcs_Index).data?.rule || ""}
          </div>
          `;
  
        game.container.appendChild(this.dom);
    }

    protected onDestroy() {
        this.dom && this.dom.remove();
    }

    clickClose = () => {
        this.hidePanel();
    }

    // @render
    // render() {
    //     const {ruleInfo = ""} = store;
    //     this.setRuleTxt(ruleInfo);
    // }

    setRuleTxt(txt: string) {

        this.spNode.getComponent(HTMLRichText).html = txt;

        this.spNode.once(HTMLRichText.EventType.AFTER_RENDER, ()=>{

            const {width: pw, height: ph} = this.spNode.getComponent(UITransform);

            const width = this.spNode.parent.getComponent(UITransform).width;

            const height = ph * width / pw;

            this.spNode.getComponent(UITransform).setContentSize(width, height);

        });

    }

}
