import { _decorator, Component, easing, tween, v3 } from 'cc';

const { ccclass } = _decorator;

@ccclass('PopoverFade')
export class PopoverFade extends Component {

  start() {
    tween(this.node)
      .repeatForever(
        tween(this.node)
          .delay(5)
          .to(0.666, { scale: v3(0, 0, 0) }, { easing: easing.smooth })
          .delay(2)
          .to(0.666, { scale: v3(1, 1, 1) }, { easing: easing.smooth })
      )
      .start();
  }

}
