import { getQueryParamValue } from "./Utils/Utils";
import { sendWebNet, WebNetName } from "./Utils/WebNet/WebNet";

export function isIos(): boolean {
    const ua = navigator.userAgent.toLowerCase();
    return /iphone|ipod|ipad/i.test(ua);
}

/**
 * 
 * @param type - 1 保存图片 2分享图片
 * @param base64Img - 图片base64
 * 
 */
export function saveOrShareImage(jsonObj: SaveOrShareImageParams): void {
    try {
        //@ts-ignore
        let isNewIos = window.webkit && window.webkit.messageHandlers && window.webkit.messageHandlers.HZBankOCAPI
        if (isNewIos) {
            //@ts-ignore
            HZBankNewIosApp = window.webkit.messageHandlers.HZBankOCAPI
        } else {
            //@ts-ignore
            HZBankApp = window.SysClientJs || window.HZBankJSONModel
        }
        // @ts-ignore
        HZBank.saveOrShareImage(jsonObj);
    } catch (error) {

    }
}

/**
 * goTimingPage
 * 跳转实现6s倒计时并完成后记录客户端缓存
 * @param pageType - 0:mpaas页面 1:html三方页面
 * @param url - 加载mpaas页面地址
 * @param describe - 倒计时秒数前方描述xXXX:10s
 * @param completeText - 倒计时结束文字
 * @param time - 倒计时秒数 单位 (秒)
 * @param saveKey - 倒计时结束存储数据使用的key
 * @param businessData - 倒计时结束时除时间以外存储的业务数据数据
 */
export function goTimingPage(params: TimingPageParams): void {
  // 解决cookie问题
  sendWebNet(WebNetName.tempSaveCookie, {}, { hideMsg: true }).then((res) => {
      if (res?.data) {
          localStorage.setItem("db_temp_cookie", res.data);
          // setCookieId(res.data);
      }
  }).finally(() => {
    console.log('goTimingPage', params)
    // const params = {
    //     pageType: '0',
    //     url: 'login/login.html#/login/login',
    //     describe: '我要开始倒计时了',
    //     completeText: '我要结束倒计时了',
    //     time: '6',
    //     saveKey: 'saveParams',
    //     businessData: {
    //         customerId: '109722901',
    //         aeae: '1097高娜娜'
    //     }
    // };
    // @ts-ignore
    HZBank.goTimingPage(params);
  })
}

/** 获取客户端缓存 */
export function getPersistentData(saveKey: string) {
    return new Promise((resolve, reject) => {
        // @ts-ignore
        HZBank.getPersistentData(saveKey, function (data) {
            console.log(data, '结束倒计时拿到数据缓存')
            resolve(data)
        })
    })
}

/** 获取客户端版本 */
export function getAppCurrentVersion() {
    return new Promise((resolve, reject) => {
        // @ts-ignore
        HZBank.getAppCurrentVersion(function (data) {
            console.log('获取客户端版本', data)
            resolve(data)
        })
    })
}

/**
 * 版本比较方法
 * 1: V1 > V2
 * 0: V1 = V2
 * -1: v1 < V2
 */
export function compareVersion(v1, v2) {
    console.log('compareVersion v1===> ', v1);
    console.log('compareVersion v2===> ', v2);
    v1 = v1?.split(".") || [];
    v2 = v2.split(".");
    const len = Math.max(v1.length, v2.length)
    // 调整两版本号位数相同
    while (v1.length < len) {
        v1.push('0')
    }
    while (v2.length < len) {
        v2.push('0')
    }
    // 遍历每位大小
    for (let i = 0; i < len; i++) {
        const num1 = parseInt(v1[i])
        const num2 = parseInt(v2[i])
        if (num1 > num2) {
            return 1
        } else if (num1 < num2) {
            return -1
        }
    }
    return 0
}

/**
 * 跳转客服
 */
export function appJumpCustomer(url) {
  // 解决cookie问题
  sendWebNet(WebNetName.tempSaveCookie, {}, { hideMsg: true }).then((res) => {
      if (res?.data) {
          localStorage.setItem("db_temp_cookie", res.data);
          // setCookieId(res.data);
      }
  }).finally(() => {
    let isNewApp = false;
    try {
        // 判断是否是数字人版本
        // @ts-ignore
        HZBank.isHaveAvatarx(isNewVersion => {
            console.log('isHaveAvatarx返回参数：', isNewVersion)
            // @ts-ignore
            if (HZBank.isHmApp()) {
                // 如果是纯血鸿蒙 返回的是对象 特殊处理一下
                isNewApp = !!isNewVersion?.isNewVersion;
            } else {
                isNewApp = !!isNewVersion;
            }
        }) 
    } catch(error) {
        isNewApp = false;
    }
    setTimeout(() => {
        if (isNewApp) {
            console.log('跳转新版客服')
            // const initialQs = getQueryParamValue(url, 'initialQuestion') || ""
            // console.log('初始问题:', initialQs)
            // @ts-ignore
            HZBank.setData('DIGITAL_OR_HEADSET_ENTER_MARK', {
                homeIndex: '1',
                // queryParam: initialQs,
                queryParam: url,
            })
            openAvatarxTransitionalPage();
        } else {
            console.log('跳转旧版客服')
            // @ts-ignore
            HZBank.openThirdUrl(url);
        }
        // https://test.hccb.cc/kefu/dist/#/chatNew?channelKey=sj5&initialQuestion=杭银财富节攻略
    }, 100)
  })
}

/**
 * 新版本客服
 */
export function openAvatarxTransitionalPage() {
    let params = {
        url: "appHome/homeMiddleDigital",
        loadType: '1',
        closePage: 'false',
    }
    // @ts-ignore
    HZBank.openAvatarxTransitionalPage(params)
}

export function appJump(url, pageFlag = "0") {
    // 解决cookie问题
    sendWebNet(WebNetName.tempSaveCookie, {}, { hideMsg: true }).then((res) => {
        if (res?.data) {
            localStorage.setItem("db_temp_cookie", res.data);
            // setCookieId(res.data);
        }
    }).finally(() => {
        const params = {
            'pageFlag': pageFlag,
            'formUrl': location.href,
            "fromUrl": location.href,
            "jumpType": 1
        }
        console.info('appJump url', url)
        console.info('appJump params', params)
        // @ts-ignore
        HZBank.goPage(url, params);
    })
}

export function resetBackCookie(duibaTempCookieId) {
    return new Promise(async (resolve) => {
        $.ajax({
            url: "/autoLogin/resetCookie", //请求地址
            type: 'GET',   //请求方式
            data: { duibaTempCookieId }, //请求参数
            dataType: "json",     // 返回值类型的设定,暂时只有json
            async: true,   //是否异步
            success: () => {
                resolve('success');
            },
            error: (e) => {
                resolve(e);
            },
        });
    });
}



interface TimingPageParams {
    pageType: string;
    url: string;
    describe: string;
    completeText: string;
    time: string;
    saveKey: string;
    businessData: any
    // {
    //     customerId: string;
    //     aeae: string;
    // }
}

interface SaveOrShareImageParams {
    type: number;
    base64Img: string;
}

declare global {
    interface Window {
        HZBank?: {
            saveOrShareImage: (params: SaveOrShareImageParams) => void;
            goTimingPage: (params: TimingPageParams) => void;
        }
    }
}
