import mobx from "mobx";
import { getPxToken, getWebData, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { changeScene, showPanel, showToast } from "../../Module/UIFast";
import { MD5 } from "crypto-js";
import { md5 } from "../Utils/Md5";
import { runMainPage } from "../Scenes/runMainPage";
import { runGamePage } from "../Scenes/runGamePage";

const { makeAutoObservable } = mobx;

class Store {
    BRANCH_TYPE = 'tcs'

    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const { success, data } = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        const resData = data || {};
        this.frontVariable = resData;
    }

    ruleInfo: string = "";

    async updateRule() {
        const { success, data } = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    tcsStartId: {};
    startsNet = true
    async startTCS() {
        console.log("this.startsNet", this.startsNet)
        if (!this.startsNet) {
            return
        }
        this.startsNet = false
        const { success, data } = await sendWebNetWithToken(WebNetName.tcs_Start);
        if (!success) {
            this.startsNet = true
            changeScene(runMainPage)
        }
        this.tcsStartId = data.startId;
        changeScene(runGamePage)
        this.startsNet = true
    }
    async submitTCS(score) {
        let sign;
        let time = new Date().getTime();
        sign = md5(`duiba2024${this.tcsStartId}${score}${time}`)
        // await getPxToken(async (msg, token) => {
        const { success, data } = await sendWebNetWithToken(WebNetName.tcs_Submit, { score, sign, startId: this.tcsStartId, timeStamp: time }, { isGet: false, headers: { 'Content-Type': "application/x-www-form-urlencoded" } });
        if (success) {
            // 结算弹窗
            await sendWebNet(WebNetName.tcs_Index);
            // showPanel(SnakeResultPanel, { ...data, score })
        } else {
            changeScene(runMainPage)
        }
        // })
    }
    lastPage = null;

}

const store: Store = makeAutoObservable(new Store());

export default store;