import { showPanel, showToast } from "../Module/UIFast";
import { getUrlParam } from "./Utils/Utils";
import { WebNetName, getWebData, sendWebNet, sendWebNetWithToken, getProjectId } from "./Utils/WebNet/WebNet";
import { UIMgr } from "db://assets/Module/UIMgr";

export default class ShareCenter {
  private static _ins: ShareCenter = null;

  public static get ins() {
    !ShareCenter._ins && (ShareCenter._ins = new ShareCenter());
    return ShareCenter._ins;
  }

  /**
     * 分享
     */
  async doShare(type, needHelp = false) {
    const { shareInfo, appKey } = getWebData(WebNetName.getFrontVariable).data;
    let url = '';
    const domain = location.origin;
    if (type == 'main') {
      // https://wxyhtst.urcb.com/wxzt/ctfront/#/authorize?redirect_uri=你们地址&forceLogin=true

      url = domain + '/customShare/share?id=Did1NTQ4NTU'; //Did1NTQ3NTE 线上测试  Did1NTQ4NTU 线上正式 分享中间页是为了分享域名与当前一致
      // url = 'https://wxyhtst.urcb.com/wxzt/ctfront/#/authorize?redirect_uri=' + encodeURIComponent(centerUrl) + '&forceLogin=true';
    } else {
      url = domain + "/projectx/" + getProjectId() + "/share.html?appId=" + getUrlParam("appID") + "&openBs=openbs&appKey=" + appKey + '&branchType=' + type;
    }
    if (needHelp) {
      const { success, data } = await sendWebNetWithToken(WebNetName.getInviteCode, { branchType: type });
      if (success) {
        url = url + '&inviteCode=' + data?.inviteCode;
      }
      const inviteInfo = shareInfo.filter(item => item.type == type)[0]
      if (this.isWeChat()) {
        UIMgr.ins.showShare();
        // FISH_TODO 
        // onUpdateShare({
        //   title: inviteInfo?.title,
        //   content: inviteInfo?.content,
        //   url: url,
        //   thumbnail: inviteInfo?.thumbnail,
        // });
        return;
      }
      console.info({
        title: inviteInfo?.title,
        content: inviteInfo?.content,
        url: url,
        thumbnail: inviteInfo?.thumbnail,
      });
      if (type == 'main') return; //初始化拦截
      // @ts-ignore
      MFS.share({
        "MATE_NAME": inviteInfo?.title,
        "MATE_SUB_NAME": inviteInfo?.content,
        "PAGE_IMAGE": inviteInfo?.thumbnail,
        "OPEN_URL": url,
        "PLATFORMS": [
          "WechatSession",
          "WechatTimeLine"
        ]
      });
    }
  }

  /** 判断微信环境 */
  isWeChat() {
    const ua = window.navigator.userAgent.toLowerCase();
    return String(ua.match(/MicroMessenger/i)) == "micromessenger";
  }
}
