import { _decorator, Button, Node, Label, v3, tween, easing, screen } from "cc";
import Panel from "db://assets/Module/Panel";
import { SCROLL_VERTICAL, ScrollList } from "../../ScrollList/ScrollList";
import { getWebData, LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../../Utils/WebNet/WebNet";
import store from "../../store/store";
import { runMainPage } from "../../Scenes/runMain/runMainPage";

const { ccclass, property } = _decorator;

export const TASK_CODE = {
  /** 分享任务 */
  SHARE: "st",
  /** 邀请任务 */
  INVITE: "it",
  /** 浏览任务 */
  BROWSE: "bt",
  /** 添加企业微信 */
  ADDQYWX: "jewt",
};

@ccclass("TaskPanel")
export class TaskPanel extends Panel {
  static bundle: string = "TaskPanel";
  static skin = "TaskPanel";
  static group = ["TaskPanel"];

  @property(Node)
  CloseBtn: Node = null;

  @property({ type: ScrollList, tooltip: "竖行滚动容器" })
  private vScroll: ScrollList;

  @property(Node)
  closeMask: Node = null;

  private _gameTimes = 0;
  get gameTimes() {
    return this._gameTimes;
  }
  4;
  set gameTimes(val) {
    this._gameTimes = val;
  }

  onShow() {
    const winH = screen.windowSize.height;

    this.node.setPosition(v3(0, -winH, 0));

    // tween(this.node)
    //     .to(0.488, {position: v3(0, 0, 0)}, {easing: easing.quadInOut})
    //     .start();
  }

  onLoad() {
    // 给document绑定一个visibilitychange事件，当前页面显示或者隐藏的时候执行该事件
    document.addEventListener("visibilitychange", this.visibilityChange);
    this.CloseBtn.on(Button.EventType.CLICK, this.handleClose, this);

    this.closeMask.on(Button.EventType.CLICK, this.handleClose, this);
  }

  onDestroy() {
    document.removeEventListener("visibilitychange", this.visibilityChange);
  }

  visibilityChange = () => {
    if (!document.hidden) {
      this.updateTaskInfo();
    } else {
      // 如果是隐藏状态执行相应的事件
    }
  };

  async start() {
    await this.updateTaskInfo();
    let data = getWebData(WebNetName.queryTasks).data;
    // data?.item?.map((v, i) => {
    //   sendLog(LOG_TYPE.EXPOSURE, 46 + i, v.code);
    // });
  }

  updateTaskInfo = async () => {
    const { boolLogin } = getWebData(WebNetName.tcs_Index).data || {};
    const [taskRes] = await Promise.all([
      sendWebNet(WebNetName.queryTasks, { branchType: store.BRANCH_TYPE }),
    ]);

    if (!taskRes?.success) return;


    this.vScroll.setDataList(
      taskRes.data.item,
      SCROLL_VERTICAL,
      [20, 20, 20],
      null,
      this.updateTaskInfo,
      this.hidePanel,
      boolLogin
    );
  };

  handleClose = () => {
    // sendLog(LOG_TYPE.CLICK, 15);
    this.hidePanel();
    runMainPage.ins.getIndex();
  };
}
