import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { observer } from "../store/decorators";
import { getProjectId, getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle, getUrlParam, strFormat } from "../Utils/Utils";
import { changeScene } from "../../Module/UIFast";
import { runMainPage } from "../Scenes/runMain/runMainPage";

const { ccclass, property } = _decorator;

@observer
@ccclass('GetPrizePanel')
export default class GetPrizePanel extends Panel {

    static bundle = "GetPrizePanel";
    static skin = "GetPrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;
    @property(Label) score: Label = null;
    @property(Sprite) prizeImg: Sprite = null;
    @property(Label) prizeName: Label = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        this.score.string = this.data.score.toString();
        this.prizeName.string = strFormat(this.data.prizeName, 35);
        this.prizeImg.spriteFrame = this.data.prizeImage.toString();
    }

    clickClose = () => {
        changeScene(runMainPage)
        this.hidePanel();
    }

}
