import { showPanel, showToast } from "../Module/UIFast";
import { getUrlParam } from "./Utils/Utils";
import { WebNetName, getWebData, sendWebNet, sendWebNetWithToken, getProjectId } from "./Utils/WebNet/WebNet";
import { UIMgr } from "db://assets/Module/UIMgr";

export default class ShareCenter {
  private static _ins: ShareCenter = null;

  public static get ins() {
    !ShareCenter._ins && (ShareCenter._ins = new ShareCenter());
    return ShareCenter._ins;
  }
  // 普通分享落地页 openBs链接 (获取到前端配置项appKey和动态域名后 拼接全链接)
  shareUrl = `${location.origin}/projectx/${getProjectId()}/share.html?&appID=${getUrlParam("appID")}`;

  /** 
   * app 普通分享
   */
  onAppShare(shareParams) { //分享配置  是否为默认APP分享
     // 分享邀请链接
    console.info("shareParams", shareParams)
    let jsonObj = {
      shareUrl: shareParams.url, // 分享链接
      shareType: '2', // 分享类型，1：微信朋友圈，2：微信好友
      shareTitle: shareParams.title, // 分享标题
      shareText: shareParams.content, // 分享描述
      shareImageUrl2: shareParams.thumbnail, // 分享图片url(优先使用)
      shareImageUrl: '', // 分享图片base64
      eventName: ""
    }
    // @ts-ignore
    if (HZBank) {
      console.info("jsonObj", jsonObj)
      // @ts-ignore
      HZBank.shareWebUrl(jsonObj)
    }
  }

  /** 判断微信环境 */
  isWeChat() {
    const ua = window.navigator.userAgent.toLowerCase();
    return String(ua.match(/MicroMessenger/i)) == "micromessenger";
  }

  //生成海报
  async createPosterWithCode(inviteCode) {
    const httpUrl = `${
      location.origin
    }/projectx/${getProjectId()}/sharePage.html`;
    let actId = getWebData(WebNetName.index).data?.actId;
    const qrUrl = encodeURIComponent(
      `${httpUrl}?needLogin=true&hideMobile=%hideMobile&accountId=%accountId&unifyId=%unifyId&sign=%accountIdSign&actId=${actId}&platform=mini&isBindInfo=%isBindInfo&nickName=%nickName&userImg=%avatarUrl&shareCode=${inviteCode}`
    );
    // https://www-int2.sino-life.com
    console.info(
      "二维码配置链接",
      "https://www.sino-life.com" + "?qr=" + encodeURIComponent("needLogin=true&url=" + qrUrl)
    );
    return "https://www.sino-life.com" + "?qr=" + encodeURIComponent("needLogin=true&url=" + qrUrl);
  }

  /**
   * 助力
   */
  async doAssist() {
    const inviteCode = getUrlParam("shareCode");
    if (!inviteCode) return false;
    const { success, code, message } = await sendWebNetWithToken(
      WebNetName.doAssist,
      { inviteCode },
      null,
    );
    if (success) {
      showToast("助力成功");
    } else {
      // let tip = message;
      // if (+code == 200303) {
      //   tip = "您已达今日助力上限";
      // }
      // showPanel(AssistFailPanel, { tip });
      // if ([200303, 200304, 200306, 200308,].indexOf(+code) > -1) {
      // } else {
      //     showToast(message);
      // }
    }
    history.replaceState({}, "", location.href.replace(new RegExp(`[?&]shareCode=[^&]*`), ""));
  }
}
