import { _decorator, AudioClip, Button, Component, Label, Node } from 'cc';
import { getProjectId, getWebData, LOG_TYPE, sendLog, sendWebNet, WebNetName } from '../Utils/WebNet/WebNet';
import { changeScene, showPanel, showToast } from '../../Module/UIFast';
import Scene from '../../Module/Scene';
import { runGamePage } from './runGamePage';
import { TaskPanel } from '../Panels/TaskPanel/TaskPanel';
import RulePanel from '../Panels/RulePanel';
import store from '../store/store';
import { _asyncThrottle, getUrlParam } from '../Utils/Utils';
import { AudioMgr } from '../../core_tgx/base/AudioMgr';
import ShareCenter from '../ShareCenter';
const { ccclass, property } = _decorator;

@ccclass('runMainPage')
export class runMainPage extends Scene {

    static bundle: string = "runMainPage";
    static skin: string = "runMainPage";

    @property(Node)
    backBtn: Node = null;

    @property(Node)
    ruleBtn: Node = null;

    @property(Node)
    prizeBtn: Node = null;

    @property(Node)
    lightOn: Node = null;
    @property(Node)
    lightOff: Node = null;
    @property(Label)
    venueLab: Label = null;

    @property(Node)
    shareBtn: Node = null;

    @property(Label)
    rankLab: Label = null;
    @property(Node)
    rankBtn: Node = null;

    @property(Node)
    startBtn: Node = null;
    @property(Label)
    startLab: Label = null;

    @property(Node)
    taskBtn: Node = null;

    @property(AudioClip)
    bgMusic:AudioClip = null

    private static _ins: runMainPage = null;

    
    static get ins() {
      return runMainPage._ins;
    }
    onLoad() {
        runMainPage._ins = this;
        AudioMgr.ins.play(this.bgMusic,{loop:true})
    }

    start() {
        this.getIndex()
        this.backBtn.on(Button.EventType.CLICK, this.click_Back, this)
        this.ruleBtn.on(Button.EventType.CLICK, this.click_Rule, this)
        this.prizeBtn.on(Button.EventType.CLICK, this.click_Prize, this)
        this.shareBtn.on(Button.EventType.CLICK, this.click_Share, this)
        this.rankBtn.on(Button.EventType.CLICK, this.click_Rank, this)
        this.startBtn.on(Button.EventType.CLICK, this.click_startGame, this)
        this.taskBtn.on(Button.EventType.CLICK, this.click_Task, this)
        sendLog(LOG_TYPE.EXPOSURE,32)
        sendLog(LOG_TYPE.EXPOSURE,33)
        sendLog(LOG_TYPE.EXPOSURE,34)
        sendLog(LOG_TYPE.EXPOSURE,35)
        sendLog(LOG_TYPE.EXPOSURE,36)

    }
    async getIndex() {
        const { success, data } = await sendWebNet(WebNetName.kmdj_Index);
        if (success) {
            this.venueLab.string = `${data.lightInfo.targetTimes}次游戏超过${data.lightInfo.targetScore}分（${data.lightInfo.alreadyTimes}/${data.lightInfo.targetTimes}）`
        }
    }

    click_Back = _asyncThrottle(() => {
        sendLog(LOG_TYPE.CLICK,32)
        AudioMgr.ins.stop()
        history.back()
    })
    click_Rule = _asyncThrottle(() => {
        showPanel(RulePanel)
    })
    click_Prize = _asyncThrottle(() => {
        AudioMgr.ins.stop()
        
    })
    click_Rank = _asyncThrottle(() => {
        AudioMgr.ins.stop()
        sendLog(LOG_TYPE.CLICK,33)
    })

    click_Share = _asyncThrottle(() => {
        sendLog(LOG_TYPE.CLICK,35)
        // TODO 分享贪吃蛇落地页
        const { shareInfoRunGame } = getWebData(WebNetName.getFrontVariable).data;
        const { title, content, thumbnail } = shareInfoRunGame
        const params = {
          title: title, // 标题
          content: content, // 描述
          thumbnail: thumbnail, // 图片
          url: `${location.origin}/projectx/${getProjectId()}/yoxwt0xup.html?appKey=BT7dEExebi72zeMiUVsGdMFEs3E&openBs=openbs&appID=${getUrlParam("appID")}`, // 链接
        };
        ShareCenter.ins.onAppShare(params);
        sendWebNet(WebNetName.buriedPoint, { pageBizId: 503, share_type: 1 },{hideMsg:true})
    })
    click_Task = _asyncThrottle(() => {
        if(!this.checkActStatus()){
            return
        }
        sendLog(LOG_TYPE.CLICK,36)
        showPanel(TaskPanel)
        // showPanel(SnakeResultPanel)
    })
    click_startGame = _asyncThrottle(async () => {
        if(!this.checkActStatus()){
            return
        }
        sendLog(LOG_TYPE.CLICK,34)
        let data = getWebData(WebNetName.kmdj_Index).data
        if (data.remainGameTimes > 0) {
            // 参与活动
            if (!data.boolGuideFinish) {
                changeScene(runGamePage)
            } else {
                await store.startKMDJ()
            }
        } else {
            // 没有次数
            showToast("游戏次数不足，完成任务再来吧~")
            showPanel(TaskPanel)
        }
    })
    update(deltaTime: number) {

    }
    /** 校验活动状态 */
  checkActStatus = () => {
    const { data, timeStamp } = getWebData(WebNetName.index) || {};
    const { actStartTime, actEndTime } = data || {};
    if (actStartTime > timeStamp) {
      showToast("活动未开始");
      return false;
    } else if (actEndTime <= timeStamp) {
      showToast("活动已结束");
      return false;
    }
    return true;
  };


}


