import { _decorator, Button, Label, Node, Sprite } from "cc";
import { ScrollListItem } from "../../ScrollList/ScrollListItem";
import { _asyncThrottle, getUrlParam, strFormat } from "../../Utils/Utils";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import {
  sendWebNet,
  LOG_TYPE,
  sendLog,
  sendWebNetWithToken,
  WebNetName,
  getWebData,
  getProjectId,
} from "db://assets/Scripts/Utils/WebNet/WebNet";
import ShareCenter from "../../ShareCenter";

const { ccclass, property } = _decorator;

@ccclass("TaskItem")
export class TaskItem extends ScrollListItem {
  @property({ type: Node, displayName: "去完成" }) doComplete: Node = null;
  @property({ type: Node, displayName: "领取" }) receivePrize: Node = null;
  @property({ type: Node, displayName: "已完成" }) completed: Node = null;

  @property({ type: Sprite, displayName: "图标" }) taskIcon: Sprite = null;

  @property({ type: Label, displayName: "标题" }) title: Label = null;
  @property({ type: Label, displayName: "副标题" }) subTitle: Label = null;

  updateTask: Function = null;
  hidePanel: Function = null;
  data = null;
  dp = null;
  timer2 = null;
  curTime = 15;
  cutDownRef = document.getElementById("cutDownTime");
  index = 0
  onLoad() {
    this.doComplete.on(Button.EventType.CLICK, this.doCompleteFunc, this);
    this.receivePrize.on(Button.EventType.CLICK, this.receivePrizeFunc, this);
    // this.completed.on(Button.EventType.CLICK, this.doCompleteFunc, this);
  }

  onItemRender(data, index, param: any[]) {
    this.data = data;
    this.index = index;
    this.updateTask = param[0];
    this.hidePanel = param[1];

    const { taskStatus, title, subTitle, code, icon, completedSize, intervalLimitSize } = data;
    this.title.string = strFormat(title, 20);

    this.subTitle.string = !!subTitle ? strFormat(subTitle, 30) : "";
    this.taskIcon.spriteFrame = icon;

    this.doComplete.active = false;
    this.receivePrize.active = false;
    this.completed.active = false;

    if (+taskStatus === 0) {
      this.doComplete.active = true;
      // sendLog(LOG_TYPE.EXPOSURE, 16, 1, code);
    } else if (+taskStatus === 1) {
      this.receivePrize.active = true;
      // sendLog(LOG_TYPE.EXPOSURE, 16, 2, code);
    } else if (+taskStatus === 2) {
      this.completed.active = true;
    }
  }
  createEvent(data, detail = null) {
    let event = new CustomEvent(data, {
      detail: detail,
    });
    return event;
  }

  /**去完成任务 */
  doCompleteFunc = _asyncThrottle(async () => {
    const { jumpUrl, code, desc, completedSize, intervalLimitSize, extra } = this.data;
    // if (!this.checkActStatus()) return;

    sendLog(LOG_TYPE.CLICK, 46 + this.index, code);
    switch (code) {
      case "share": //邀请用户任务
        const { shareInfoRunGame } = getWebData(WebNetName.getFrontVariable).data;
        const { title, content, thumbnail } = shareInfoRunGame
        const params = {
          title: title, // 标题
          content: content, // 描述
          thumbnail: thumbnail, // 图片
          url: `${location.origin}/projectx/${getProjectId()}/yoxwt0xup.html?appKey=BT7dEExebi72zeMiUVsGdMFEs3E&openBs=openbs&appID=${getUrlParam("appID")}`, // 链接
        };
        ShareCenter.ins.onAppShare(params);
        sendWebNet(WebNetName.buriedPoint, { pageBizId: 503, share_type: 1 }, { hideMsg: true })
        setTimeout(async () => {
          const { data, success } = await sendWebNetWithToken(WebNetName.doCompleted, { taskCode: code });
        }, 3000);
        break;
      default:
        break;
    }
  })

  /** 校验活动状态 */
  checkActStatus = () => {
    const { data, timeStamp } = getWebData(WebNetName.index) || {};
    const { actStartTime, actEndTime } = data || {};
    if (actStartTime > timeStamp) {
      showToast("活动未开始");
      return false;
    } else if (actEndTime <= timeStamp) {
      showToast("活动已结束");
      return false;
    }
    return true;
  };

  /**领取奖励 */
  receivePrizeFunc = _asyncThrottle(async () => {
    const { code, prizePendingCode } = this.data;
    // sendLog(LOG_TYPE.CLICK, 16, 2, code);

    const { success, data } = await sendWebNetWithToken(WebNetName.sendPrize, { taskCode: code, prizePendingCode });

    if (!success) {
      return;
    }

    const count = data.options[0].sendCount;
    showToast(`游戏次数+${count}`);

    this.updateTask();
  });
}
