import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { observer } from "../store/decorators";
import { getProjectId, getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle, getUrlParam } from "../Utils/Utils";
import { changeScene } from "../../Module/UIFast";
import { runMainPage } from "../Scenes/runMain/runMainPage";

const { ccclass, property } = _decorator;

@observer
@ccclass('GetCodePanel')
export default class GetCodePanel extends Panel {

    static bundle = "GetCodePanel";
    static skin = "GetCodePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;
    @property(Label) score: Label = null;

    @property(Label) code0: Label = null;
    @property(Label) code1: Label = null;
    @property(Label) code2: Label = null;
    @property(Label) code3: Label = null;
    @property(Label) code4: Label = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        this.score.string = this.data.score.toString();
        this.data.codeNumber.toString()?.split("")?.forEach((item, index) => {
            this[`code${index}`].string = item;
        });
    }

    clickClose = () => {
        changeScene(runMainPage)
        this.hidePanel();
    }

}
