// 更新分享
export function wxShare(shareOpt) {
  const { title, content, url, thumbnail } = shareOpt || {};
  let share = {
    title,
    desc: content,
    link: url,
    imgUrl: thumbnail
  };
  console.info('wxShare分享信息', share)
  // @ts-ignore
  wx.onMenuShareTimeline({
    title: share.title,
    desc: share.desc,
    link: share.link,
    imgUrl: share.imgUrl,
    success: function () {
    },
    cancel: function () {
    }
  });
  // @ts-ignore
  wx.onMenuShareAppMessage({
    title: share.title,
    desc: share.desc,
    link: share.link,
    imgUrl: share.imgUrl,
    success: function () {
    },
    cancel: function () {
    }
  });
}

// 初始化微信分享
export function initWx(url = location.href) {
  return new Promise(function (resolve) {
    $.ajax({
      type: 'get',
      url: '/wechatShare/getShareInfo/v2',
      data: {
        wxdebug: false,
        url: url
      },
      cache: false,
      dataType: 'json',
      success: function (res) {
        if (!res.success) {
          resolve(false)
          return;
        }
        // @ts-ignore
        wx.config({
          debug: false,
          appId: res.wxappid,
          timestamp: res.wxtimestamp,
          nonceStr: res.wxnonceStr,
          signature: res.wxsignature,
          jsApiList: ['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage']
        });

        // @ts-ignore
        wx.error(function (res) {
          console.error("wx error", res);
          resolve(false)
        });

        // @ts-ignore
        wx.ready(function () {
          resolve(true)
        });
      },
      error: function (err) {
        resolve(false)
      }
    });
  })
}
