import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer } from "../store/decorators";
import { getProjectId, getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle, getUrlParam } from "../Utils/Utils";
import { changeScene } from "../../Module/UIFast";
import { runMainPage } from "../Scenes/runMain/runMainPage";

const { ccclass, property } = _decorator;

@observer
@ccclass('NoPrizePanel')
export default class NoPrizePanel extends Panel {

    static bundle = "NoPrizePanel";
    static skin = "NoPrizePanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
    }

    clickClose = () => {
        changeScene(runMainPage)
        this.hidePanel();
    }

}
