import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer } from "../store/decorators";
import ShareCenter from "../ShareCenter";
import { getWebData, WebNetName } from "../Utils/WebNet/WebNet";

const { ccclass, property } = _decorator;

@observer
@ccclass('LimitPanel')
export default class LimitPanel extends Panel {

    static bundle = "LimitPanel";
    static skin = "LimitPanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.bindCard);
    }

    async start() {
    }

    bindCard = () => {
        const urlType = JSON.parse(getWebData(WebNetName.getFrontVariable)?.data?.bindCardUrl || "") || {};
        console.info('urlType', urlType);
        if (ShareCenter.ins.isWeChat()) {
            location.href = urlType.weixinUrl
        } else {
            location.href = urlType.appUrl
            // MFS.openWebView({
            //   // "title": "百度", // 非必填
            //   "url": urlType.appUrl,
            // })
        }
    }

    clickClose = () => {
        this.hidePanel();
    }

}
