import { _decorator, Component, easing, tween, v3 } from 'cc';

const { ccclass } = _decorator;

@ccclass('ArrowBreath')
export class ArrowBreath extends Component {

  start() {
    tween(this.node)
      .repeatForever(
        tween(this.node)
          .to(0.666, { scale: v3(1.2, 1.2, 1.2) }, { easing: easing.smooth })
          .to(0.666, { scale: v3(0.95, 0.95, 0.95) }, { easing: easing.smooth })
      )
      .start();
  }

}
