import mobx from "mobx";
import { getPxToken, getWebData, sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { changeScene, showPanel, showToast } from "../../Module/UIFast";
import { MD5 } from "crypto-js";
import { md5 } from "../Utils/Md5";
import { runMainPage } from "../Scenes/runMain/runMainPage";
import { runGamePage } from "../Scenes/runGamePage";
import NoPrizePanel from "../Panels/NoPrizePanel";
import GameFailPanel from "../Panels/GameFailPanel";
import GetCodePanel from "../Panels/GetCodePanel";
import GetPrizePanel from "../Panels/GetPrizePanel";

const { makeAutoObservable } = mobx;

class Store {
    BRANCH_TYPE = 'tcs'

    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const { success, data } = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        const resData = data || {};
        this.frontVariable = resData;
    }

    ruleInfo: string = "";

    async updateRule() {
        const { success, data } = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    tcsStartId: {};
    startsNet = true
    async startTCS() {
        console.log("this.startsNet", this.startsNet)
        if (!this.startsNet) {
            return
        }
        this.startsNet = false
        const { success, data } = await sendWebNetWithToken(WebNetName.tcs_Start);
        if (!success) {
            this.startsNet = true
            changeScene(runMainPage)
        }
        this.tcsStartId = data.startId;
        changeScene(runGamePage)
        this.startsNet = true
    }
    async submitTCS(score) {
        let timeStamp = Date.now();
        let signAt = `${store.tcsStartId}${score}${timeStamp}`;
        let sign = md5(signAt);
        const { success, data } = await sendWebNetWithToken(WebNetName.tcs_Submit, {
            startId: store.tcsStartId,
            score,
            sign,
            timeStamp,
        }, { isGet: false });

        if (success) {
            const { prizeId, boolReachThresholdScore } = data || {}
            // 奖品Id thanks:谢谢参与  幸运码:以sp_code 开头 sp_code_1st(一等奖),sp_code_2nd(二等奖),sp_code_3rd(三等奖),sp_code_4th(四等奖),sp_code_normal(未中奖)
            if (boolReachThresholdScore) { // 达到门槛分数
                if (prizeId === 'thanks') { // 未中奖
                    showPanel(NoPrizePanel)
                } else if (prizeId == 'sp_code_normal') { // 幸运码-未中奖
                    showPanel(GameFailPanel, { score, ...data })
                } else if (prizeId.indexOf('sp_code') >= 0) { // 抽中幸运码-n等奖
                    showPanel(GetCodePanel, { score, ...data })
                } else { // 抽中权益
                    showPanel(GetPrizePanel, { score, ...data })
                }
            } else { // 未达到门槛分数
                showPanel(GameFailPanel, { score, ...data })
            }
        } else {
            // 接口异常
            changeScene(runMainPage);
        }
    }
    lastPage = null;

}

const store: Store = makeAutoObservable(new Store());

export default store;