import { _decorator, Button, Label, Node, RichText, Sprite } from "cc";
import { ScrollListItem } from "../../ScrollList/ScrollListItem";
import { _asyncThrottle, getUrlParam, strFormat } from "../../Utils/Utils";
import { changeScene, showPanel, showToast } from "db://assets/Module/UIFast";
import {
  sendWebNet,
  LOG_TYPE,
  sendLog,
  sendWebNetWithToken,
  WebNetName,
  getWebData,
  getProjectId,
} from "db://assets/Scripts/Utils/WebNet/WebNet";
import ShareCenter from "../../ShareCenter";
import store from "../../store/store";
import NotLoginPanel from "../NotLoginPanel";
import TaskTipsPop_jjk from "../TaskTipsPop_jjk";
import TaskTipsPop_wx from "../TaskTipsPop_wx";
import TaskTipsPop_qw from "../TaskTipsPop_qw";
import TaskTipsPop_zfb from "../TaskTipsPop_zfb";

const { ccclass, property } = _decorator;

@ccclass("TaskItem")
export class TaskItem extends ScrollListItem {
  @property({ type: Node, displayName: "去完成" }) doComplete: Node = null;
  @property({ type: Node, displayName: "领取" }) receivePrize: Node = null;
  @property({ type: Node, displayName: "已完成" }) completed: Node = null;

  @property({ type: Label, displayName: "标题" }) title: Label = null;
  @property({ type: RichText, displayName: "副标题" }) subTitle: RichText = null;

  updateTask: Function = null;
  hidePanel: Function = null;
  boolLogin: Boolean = false;
  data = null;
  index = 0
  onLoad() {
    this.doComplete.on(Button.EventType.CLICK, this.goToComplete, this);
    this.receivePrize.on(Button.EventType.CLICK, this.getPrize, this);
    this.completed.on(Button.EventType.CLICK, this.goJumpCycle, this);
  }

  onItemRender(data, index, param: any[]) {
    this.data = data;
    this.index = index;
    this.updateTask = param[0];
    this.hidePanel = param[1];
    this.boolLogin = param[2];

    const { taskStatus, title, subTitle, options, completedSize, intervalLimitSize } = data;
    const titleStr = `${title}(${completedSize}/${intervalLimitSize})`
    this.title.string = strFormat(titleStr, 27);
    this.subTitle.string = `${subTitle || ''}<color=#e63323><b><size=28>+${options[0]?.sendCount || 0}</size></b></color>`;

    this.doComplete.active = false;
    this.receivePrize.active = false;
    this.completed.active = false;

    if (+taskStatus === 0) {
      this.doComplete.active = true;
      // sendLog(LOG_TYPE.EXPOSURE, 16, 1, code);
    } else if (+taskStatus === 1) {
      this.receivePrize.active = true;
      // sendLog(LOG_TYPE.EXPOSURE, 16, 2, code);
    } else if (+taskStatus === 2) {
      this.completed.active = true;
    }
  }
  createEvent(data, detail = null) {
    let event = new CustomEvent(data, {
      detail: detail,
    });
    return event;
  }

  /**去完成任务 */
  goToComplete = _asyncThrottle(async () => {
    if (!this.boolLogin) {
      showPanel(NotLoginPanel, {}, true)
      return
    }
    const { id, code, desc } = this.data;

    // 任务code
    // bank_cqj_alipay_1_2025: 完成借记卡支付宝快捷支付一笔
    // bank_cqj_wechatpay_1_2025: 完成借记卡微信快捷支付一笔
    // bank_task_qywx_2024: 添加活动小助手企微好友
    // bank_cqj_jjkin_2025: 完成借记卡账户入账一笔
    if (code == "bank_cqj_alipay_1_2025") {
      showPanel(TaskTipsPop_zfb)
      return;
    }
    if (code == "bank_cqj_wechatpay_1_2025") {
      showPanel(TaskTipsPop_wx)
      return;
    }
    if (code == "bank_task_qywx_2024") {
      showPanel(TaskTipsPop_qw)
      return;
    }
    if (code == "bank_cqj_jjkin_2025") {
      showPanel(TaskTipsPop_jjk)
      return;
    }

    if (code.indexOf('bank_bind_wechat') > -1) {
      showToast('请前往微信首页-我-服务-钱包中添加本行储蓄卡')
      // this.goToLink(desc);
      return;
    }
    if (code.indexOf('bank_bind_zfb') > -1) {
      showToast('请前往支付宝首页-我的-银行卡中添加本行储蓄卡')
      // this.goToLink(desc);
      return;
    }
    if (code.indexOf('bank_consume_10') > -1) {
      showToast('请打开丰收互联APP进行“扫码消费”或“线上转账”')
      // this.goToLink(desc);
      return;
    }
    if (code.indexOf('jump') > -1) {
      await this.doCompleteTask();
      this.goToLink(desc);
      return;
    }
    if (code.indexOf('bank') > -1) {
      this.goToLink(desc);
      return;
    }

    switch (code) {
      case 'invite':
        // 邀请
        ShareCenter.ins.doShare(store.BRANCH_TYPE, true);
        break;
    }
  })

  goToLink = (desc) => {
    console.info('desc', desc)
    let jumpUrl = JSON.parse(desc)
    console.info('jumpUrl', jumpUrl)
    if (ShareCenter.ins.isWeChat()) {
      jumpUrl.weixinUrl && (location.href = jumpUrl?.weixinUrl);
    } else {
      location.href = jumpUrl?.appUrl
      // MFS.openWebView({
      //   // "title": "百度", // 非必填
      //   "url": jumpUrl?.appUrl,
      // })
    }
  }

  doCompleteTask = async () => {
    const { id, code } = this.data;
    const { data, success } = await sendWebNetWithToken(WebNetName.doCompleted, {
      taskId: id,
      taskCode: code,
      branchType: store.BRANCH_TYPE
    }, { isGet: false });
    if (success) {
      await this.updateTask();
    }
  }

  getPrize = _asyncThrottle(async () => {
    const { id, code, prizePendingCode } = this.data;
    const { success, data } = await sendWebNetWithToken(
      WebNetName.sendPrize,
      { taskId: id, taskCode: code, prizePendingCode, branchType: store.BRANCH_TYPE },
      { isGet: false }
    );
    if (success) {
      showToast('领取成功')
      this.updateTask();
    }
  })

  goJumpCycle = _asyncThrottle(async () => {
    const { id, code, desc } = this.data;
    if (code?.indexOf('jump_cycle') > -1) {
      await this.doCompleteTask();
      this.goToLink(desc);
      return;
    }
  })

}
