import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer } from "../store/decorators";
import ShareCenter from "../ShareCenter";
import { getProjectId, getWebData, LOG_TYPE, sendLog, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle, getUrlParam } from "../Utils/Utils";

const { ccclass, property } = _decorator;

@observer
@ccclass('NotLoginPanel')
export default class NotLoginPanel extends Panel {

    static bundle = "NotLoginPanel";
    static skin = "NotLoginPanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.login);
    }

    async start() {
        sendLog(LOG_TYPE.EXPOSURE, 10);
    }

    login = _asyncThrottle(() => {
        sendLog(LOG_TYPE.CLICK, 10);
        // MFS.login({
        //   "channel": "CHANNEL_CODE", // 需要在认证系统申请
        //   "callback": "loginCallback"
        // })
        // window.loginCallback = function (data) {
        const { centerUrl } = getWebData(WebNetName.getFrontVariable)?.data || {};
        let activityUrl = centerUrl + '&projectID=' + getProjectId();
        if (getUrlParam('inviteCode') && getUrlParam('inviteCode') != '') {
            activityUrl = activityUrl + '&inviteCode=' + getUrlParam('inviteCode');
        }
        if (getUrlParam('branchType') && getUrlParam('branchType') != '') {
            activityUrl = activityUrl + '&branchType=' + getUrlParam('branchType');
        }
        if (getUrlParam('shareCode') && getUrlParam('shareCode') != '') {
            activityUrl = activityUrl + '&shareCode=' + getUrlParam('shareCode');
        }
        //线上测试
        // let openUrl = 'https://wxyhtst.urcb.com/wxzt/ctfront/#/authorize?redirect_uri=' + encodeURIComponent(activityUrl) + '&forceLogin=true';
        // 线上正式
        let openUrl = 'https://wechat.urcb.com/wxzt/ctfront/#/authorize?redirect_uri=' + encodeURIComponent(activityUrl) + '&forceLogin=true';
        // var data = JSON.parse(openUrl);
        // console.log(data);
        console.info('openUrl', openUrl)
        location.href = openUrl;
        // }
    })

    clickClose = () => {
        this.hidePanel();
    }

}
