import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { observer } from "../store/decorators";
import { getProjectId, getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { _asyncThrottle, getUrlParam } from "../Utils/Utils";
import { changeScene } from "../../Module/UIFast";
import { runMainPage } from "../Scenes/runMain/runMainPage";

const { ccclass, property } = _decorator;

@observer
@ccclass('GameFailPanel')
export default class GameFailPanel extends Panel {

    static bundle = "GameFailPanel";
    static skin = "GameFailPanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) btn: Node = null;
    @property(Label) score: Label = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.btn.on(Button.EventType.CLICK, this.clickClose);
    }

    async start() {
        this.score.string = this.data.score.toString();
    }

    clickClose = () => {
        changeScene(runMainPage)
        this.hidePanel();
    }

}
