import { _decorator, Component, Enum, Material, MeshRenderer, Node,Animation, randomRangeInt, find } from 'cc';
import { CarColors } from '../CarColorsGlobalTypes';
import { EDITOR_NOT_IN_PREVIEW } from 'cc/env';
const { ccclass, property } = _decorator;


@ccclass('RoleCarColorsComponent')
export class RoleCarColorsComponent extends Component {
    @property(Animation)
    animation: Animation = null
    @property({type: Enum(CarColors)})
    get color(){
        return this._color
    }
    set color(value){
        this._color = value
        this.changeColor()
    }

    @property({type: Enum(CarColors)})
    private _color: CarColors = CarColors.Blue

    @property({
        type: [Material]
    })
    colorMaterials: Array<Material> = []

    status: string = "" // sit, idle, run

    isHorizon: boolean = false

    isIntarget: boolean = false

    changeColor(){
        // if (!EDITOR_NOT_IN_PREVIEW){
        //     this.colorMaterials = find("Scene/mtl").getComponent(MeshRenderer).sharedMaterials
        // }
        this.node.children[0].getComponent(MeshRenderer).setSharedMaterial(this.colorMaterials[this.color], 0)
    }

    playWalk(){
        if (this.status === "walk") return
        this.status = "walk"
        this.animation.play("Run")
    }
    playSit(){
        this.status = "sit"
        const names = ["SitLaughing","SitTalking"]
        this.animation.play(names[randomRangeInt(0,2)])
    }
    playIdle(){
        if (this.status === "idle") return
        this.status = "idle"
        const names = ["Idle","SadIdle", "HappyIdle", "HappyIdle1"]
        this.animation.play(names[randomRangeInt(0,4)])
    }
}


