import mobx from "mobx";
import { sendWebNet, sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { showPanel, showToast } from "../../core/Module/UIFast";
import { getUrlParams } from "../Utils/WebNet/web/webTools";
import { AESDecrypt } from "../Utils/Crypto";
import { PREVIEW } from "cc/env";
import { NetTime } from "../NetTime";

const { makeAutoObservable } = mobx;


export interface IHomeInfo {
    actStartTime: number;
    actEndTime: number;
    currentTime: number;
    ruleImage: string;
    freeTimes: number;
    creditsNum: number;
    gameCreditsEach: number;
    qgNum: number;
    unparkQgNum: number;
    unparkCreditsNum: number;
    boxConfigs: {
        id: string;
        targetLevel: string;
        status: "1" | "2" | "3";
    }[]
}

class Store {

    frontVariable: { [key in string]: any } = {};

    async updateFrontVariable() {
        const { success, data } = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = null;

    async updateIndex() {
        const { success, data, timeStamp } = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }
        NetTime.ins.setTime(timeStamp);
        this.homeInfo = data;

    }

    ruleInfo: string = "";
    async updateRule() {
        const { success, data } = await sendWebNet(WebNetName.projectRule);
        if (!success) {
            return;
        }
        this.ruleInfo = data;
    }

    checkActTime = (isAllow = false) => {

        const { actStartTime, actEndTime, currentTime } = this.homeInfo || {};

        if (actStartTime > currentTime) {
            console.log("活动未开始");
            showToast("活动未开始");
            return false;
        }
        if (actEndTime < currentTime && !isAllow) {
            console.log("活动已结束");
            showToast("活动已结束");
            return false;
        }
        // console.log("checkActTime");

        return true;
    };

    enter: boolean = false;
    async doAssist() {
        const inviteCode = getUrlParams("inviteCode");
        if (!inviteCode) return;

        this.enter = true;

        const { success, data } = await sendWebNetWithToken(WebNetName.doAssist, { inviteCode });
        if (!success) return;

        showToast(data.extra);
    }

}


const store: Store = makeAutoObservable(new Store());

export default store;
