import {
    _decorator,
    Node, Sprite, SpriteFrame, tween, UIOpacity, Widget,
} from "cc";
import Scene from "db://assets/core/Module/Scene";

import { changeScene } from "db://assets/core/Module/UIFast";
import { MainGame } from "db://assets/Scripts/Scenes/MainGame/MainGame";
import Svga from "db://assets/core/Component/Svga/Svga";
import { LOG_TYPE, sendLog } from "db://assets/Scripts/Utils/WebNet/WebNet";

const { ccclass, property } = _decorator;

@ccclass('GuideScene')
export class GuideScene extends Scene {

    static bundle: string = "GuideScene";
    static skin: string = "GuideScene";


    @property(Node) tipNode: Node = null;
    @property(Sprite) tipSp: Sprite = null;
    @property(Svga) svga: Svga = null;

    @property({ type: [Node] }) guideList: Node[] = [];
    @property({ type: [SpriteFrame] }) tipList: SpriteFrame[] = [];

    guideIndex: number = -1;
    canNext: boolean = true;

    onLoad() {
        this.nextGuide();
        this.node.on(Node.EventType.TOUCH_END, ()=>{
            sendLog(LOG_TYPE.CLICK, 6 + this.guideIndex);
            this.nextGuide();
        }, this);

        // this.svga.node.on(Svga.EventType.END_FRAME, this.onSvgaEnd, this);

    }

    // onSvgaEnd() {
    //     this.canNext = true;
    // }

    nextGuide() {
        if (!this.canNext) return;
        this.canNext = false;

        sendLog(LOG_TYPE.EXPOSURE, 6 + this.guideIndex);

        this.svga.play();
        tween(this.tipSp.getComponent(UIOpacity))
            .set({ opacity: 0 })
            .delay(0.444)
            .to(0.444, { opacity: 255 })
            .call(() => {
                this.canNext = true;
            })
            .start();

        this.guideIndex++;
        if (this.guideIndex >= this.guideList.length) {
            changeScene(MainGame);
            return;
        }

        if (this.guideIndex === 5) {
            this.tipNode.getComponent(Widget).top = 805;
        } else {
            this.tipNode.getComponent(Widget).top = 337;
        }

        this.guideList.forEach((node, index) => {
            node.active = index === this.guideIndex;
        });

        this.tipSp.spriteFrame = this.tipList[this.guideIndex];
    }

}

