import Panel from "../../core/Module/Panel";
import { _decorator, Button, game, Node } from "cc";
import store from "../store/store";
import { observer, render } from "../store/decorators";

const { ccclass, property } = _decorator;

@observer
@ccclass("RulePanel")
export default class RulePanel extends Panel {

    static bundle = "RulePanel";
    static skin = "RulePanel";

    dom: HTMLDivElement;

    async onLoad() {
        // await store.updateRule();

        window["__clickRule__"] = this.clickClose;
    }

    protected onDestroy() {
        window["__clickRule__"] = null;
        this.dom && this.dom.remove();
        this.dom = null;
    }

    @render
    render() {
        // const { success, data } = await sendWebNet(WebNetName.projectRule);
        // if (!success) return

        this.setRuleTxt(store.ruleInfo);
    }

    clickClose = () => {
        this.hidePanel();
        this.dom && this.dom.remove();
    };

    setRuleTxt(txt: string) {

        if (!this.dom) {
            this.dom = document.createElement("div");
        }

        this.dom.innerHTML = `
            <div style="
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                display: flex;
                align-items: center;
                justify-content: center;
            ">
                <div style="
                    width: 100%;
                    height: 100%;
                    position: absolute;
                    top: 0;
                    overflow: auto;
                ">
                    <img
                        src="${store.homeInfo.ruleImage}"
                        style="width: 100%;"
                    >
                </div>

                <div style="
                    width: 0.65rem;
                    height: 0.65rem;
                    position: fixed;
                    left: 0.43rem;
                    top: 0.98rem;
                    background-image: url('//yun.duiba.com.cn/polaris/back.a1b432dc6caec8ef2ff6eaed85b5bdd03a38055a.png');
                    background-size: cover;
                "
                     onclick="window.__clickRule__()"
                ></div>
            </div>
        `;

        game.container.appendChild(this.dom);

        // const ruleNode = this.view['ScrollView/view/content/ruleTxt'];
        // const ruleTxt = this.ruleNode.getComponent(RichText);
        // // const content = this.view['ScrollView/view/content'];
        // ruleTxt.maxWidth = this.content.getComponent(UITransform).width;
        //
        // this.scheduleOnce(() => {
        //     ruleTxt.string = txt.replace(/<p\b.*?(?:\>|\/>)/gi, "").replace(/<\/p\>/gi, "<br/>");
        //     this.content.getComponent(UITransform).height = this.ruleNode.getComponent(UITransform).height;
        // }, 0.5);


        // this.spNode.getComponent(HTMLRichText).html = txt;

        // this.spNode.once(HTMLRichText.EventType.AFTER_RENDER, () => {

        //   const { width: pw, height: ph } = this.spNode.getComponent(UITransform);

        //   const width = this.spNode.parent.getComponent(UITransform).width;

        //   const height = ph * width / pw;

        //   this.spNode.getComponent(UITransform).setContentSize(width, height);

        // });
    }
}
