import { _decorator, Component, Enum, Material, MeshRenderer, Node, Animation, randomRangeInt, find } from 'cc';
import { CarColors } from '../CarColorsGlobalTypes';
import { EDITOR_NOT_IN_PREVIEW } from 'cc/env';

const { ccclass, property } = _decorator;


@ccclass('RoleCarColorsComponent')
export class RoleCarColorsComponent extends Component {
    @property(Animation)
    animation: Animation = null

    @property(MeshRenderer) bodyMesh: MeshRenderer = null

    @property({ type: Enum(CarColors) })
    get color() {
        return this._color
    }

    set color(value) {
        this._color = value
        this.changeColor()
    }

    @property({ type: Enum(CarColors) })
    private _color: CarColors = CarColors.Blue

    @property({
        type: [Material]
    })
    colorMaterials: Array<Material> = []

    status: string = "" // sit, idle, run

    isHorizon: boolean = false

    isIntarget: boolean = false

    changeColor() {
        // if (!EDITOR_NOT_IN_PREVIEW){
        //     this.colorMaterials = find("Scene/mtl").getComponent(MeshRenderer).sharedMaterials
        // }
        this.bodyMesh.setSharedMaterial(this.colorMaterials[this.color], 0)
    }

    playWalk() {
        if (this.status === "walk") return;
        this.node.children[0].setScale(13, 13, 13);
        this.status = "walk";
        this.animation.play("run");
    }

    playSit() {
        this.status = "sit"
        this.node.children[0].setScale(7, 7, 7);
        this.animation.play("sit");
    }

    playIdle() {
        if (this.status === "idle") return
        this.node.children[0].setScale(13, 13, 13);
        this.status = "idle";
        const names = ["idel_1", "idel_2", "idel_3"];
        this.animation.play(names[randomRangeInt(0, 4)]);
    }
}


