import { _decorator, Node } from 'cc';
import Panel from "db://assets/core/Module/Panel";
import Svga from "db://assets/core/Component/Svga/Svga";
import { showPanel } from "db://assets/core/Module/UIFast";
import { PrizePanel } from "db://assets/Scripts/Panels/PrizePanel";

const { ccclass, property } = _decorator;

@ccclass('BoxPanel')
export class BoxPanel extends Panel {
    static skin: string = "BoxPanel";
    static bundle: string = "BoxPanel";

    @property(Svga) boxSvga: Svga = null;

    onLoad() {
        super.onLoad();

        this.boxSvga.play();
        this.boxSvga.node.on(Svga.EventType.END_FRAME, this.onEndFrame, this);
    }

    start(): void {

    }

    onEndFrame = () => {
        this.hidePanel();
        showPanel(PrizePanel, this.data);
    }


}


